/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped.diff;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import uk.ac.ox.well.t2d.async.ped.BimEntry;

public class BimEntryIndex {
    protected IdStrategy idStrategy;
    protected IdLogic idLogic;
    protected DuplicateStrategy dupStrategy;
    protected LinkedHashMap<String, BimEntry> map = new LinkedHashMap();
    protected Set<String> duplicateIds = new LinkedHashSet<String>();
    protected Set<BimEntry> duplicateEntries = new LinkedHashSet<BimEntry>();

    public BimEntryIndex() {
        this(IdStrategy.SNPID, DuplicateStrategy.NONE);
    }

    public BimEntryIndex(IdStrategy ids, DuplicateStrategy dups) {
        this.idStrategy = ids;
        this.idLogic = IdStrategy.CHRPOS.equals((Object)ids) ? new IdLogic() : new ChrPosIdLogic();
        this.dupStrategy = dups;
    }

    public void addAll(Collection<BimEntry> bes) {
        for (BimEntry be : bes) {
            this.add(be);
        }
    }

    public void add(BimEntry be) {
        String id = this.idLogic.getId(be);
        BimEntry former = this.map.get(id);
        if (null == former) {
            this.map.put(id, be);
        } else {
            this.handleDuplicate(id, former, be);
        }
    }

    public void handleDuplicate(String key, BimEntry former, BimEntry latter) {
        this.duplicateIds.add(key);
        this.duplicateEntries.add(former);
        this.duplicateEntries.add(latter);
        switch (this.dupStrategy) {
            case FORMER: {
                this.map.put(key, former);
                break;
            }
            case LATTER: {
                this.map.put(key, latter);
                break;
            }
            case NONE: {
                this.map.remove(key);
                break;
            }
        }
    }

    public static class ChrPosIdLogic
    extends IdLogic {
        @Override
        public String getId(BimEntry bi) {
            return bi.getChromosome() + "_" + bi.getPosition();
        }
    }

    public static class IdLogic {
        public String getId(BimEntry bi) {
            return bi.getSnpId();
        }
    }

    public static enum DuplicateStrategy {
        FORMER,
        LATTER,
        NONE;

    }

    public static enum IdStrategy {
        SNPID,
        CHRPOS;

    }
}

