/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.well.t2d.async.ped.PedEntry;

public abstract class PedEntryIndex<TE extends PedEntry> {
    protected DuplicateStrategy dupStrategy;
    protected Map<String, TE> map = new LinkedHashMap<String, TE>();
    protected List<TE> all = new ArrayList<TE>();
    protected Set<String> duplicateIds = new LinkedHashSet<String>();
    protected Set<TE> duplicateEntries = new LinkedHashSet<TE>();

    public PedEntryIndex() {
        this(DuplicateStrategy.NEITHER);
    }

    public PedEntryIndex(DuplicateStrategy dups) {
        this.dupStrategy = dups;
    }

    public abstract String getId(TE var1);

    public abstract TE newClone(TE var1);

    public void addAll(Collection<TE> bes) {
        for (PedEntry be : bes) {
            this.add(be);
        }
    }

    public void add(TE te) {
        String id = this.getId(te);
        PedEntry former = (PedEntry)this.map.get(id);
        if (null == former) {
            this.map.put(id, te);
        } else {
            this.handleDuplicate(id, former, te);
        }
    }

    public List<TE> newIndex() {
        return this.newIndex(null);
    }

    public List<TE> newIndex(Set<String> idInclusions) {
        Collection<TE> incl = this.inclusions();
        ArrayList<PedEntry> al = new ArrayList<PedEntry>();
        int i = 0;
        for (PedEntry te1 : incl) {
            if (null != idInclusions && !idInclusions.contains(this.getId(te1))) continue;
            PedEntry te2 = this.newClone(te1);
            te2.setIndex(i);
            ++i;
            al.add(te2);
        }
        return al;
    }

    protected Collection<TE> inclusions() {
        switch (this.dupStrategy) {
            case ALL: {
                return this.all;
            }
            case NEITHER: {
                return this.neitherInclusions();
            }
        }
        return this.map.values();
    }

    protected Collection<TE> neitherInclusions() {
        LinkedHashMap<String, TE> lhm = new LinkedHashMap<String, TE>();
        lhm.putAll(this.map);
        for (String key : this.duplicateIds) {
            lhm.remove(key);
        }
        return lhm.values();
    }

    public void handleDuplicate(String key, TE former, TE latter) {
        this.duplicateIds.add(key);
        this.duplicateEntries.add(former);
        this.duplicateEntries.add(latter);
        switch (this.dupStrategy) {
            case FORMER: {
                this.map.put(key, former);
                break;
            }
            case LATTER: {
                this.map.put(key, latter);
                break;
            }
        }
    }

    public Set<String> getIncludedIds() {
        LinkedHashSet<String> hs = new LinkedHashSet<String>();
        hs.addAll(this.map.keySet());
        if (DuplicateStrategy.NEITHER.equals((Object)this.dupStrategy)) {
            hs.removeAll(this.duplicateIds);
        }
        return hs;
    }

    public Set<String> getDuplicateIds() {
        return Collections.unmodifiableSet(this.duplicateIds);
    }

    public Set<TE> getDuplicateEntries() {
        return Collections.unmodifiableSet(this.duplicateEntries);
    }

    public static enum DuplicateStrategy {
        FORMER,
        LATTER,
        NEITHER,
        ALL;

    }
}

