/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped.diff.rig;

import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.ContractGroup;
import uk.ac.ox.well.t2d.async.contracts.Demultiplexer;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.contracts.Resequencer;
import uk.ac.ox.well.t2d.async.genotype.bed.SimpleBedTransformer;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BimFamLoader;
import uk.ac.ox.well.t2d.async.ped.diff.BedOverlap;
import uk.ac.ox.well.t2d.async.ped.diff.BedOverlapCalculator;
import uk.ac.ox.well.t2d.async.ped.rig.BedDataLoader;
import uk.ac.ox.well.t2d.async.processors.BucketBase;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class BedDiffBlck
extends SubSection {
    public static final String STEM_1_KEY = "BedDiffRig.Stem1";
    public static final String STEM_2_KEY = "BedDiffRig.Stem2";
    public static final String BED_NUMBER = "BedDiffRig.BedNumber";

    public BedDiffBlck() {
        this.addProcessor(new BedMetadataLdrMplxr());
        this.addProcessor(new BimFamLoader());
        this.addProcessor(new Resequencer());
        this.addProcessor(new Demultiplexer());
        this.addProcessor(new BedOverlapCalculator());
        this.addProcessor(new BedLdrMplxr());
        this.addProcessor(new BedDataLoader());
        this.addProcessor(new SimpleBedTransformer());
        this.addProcessor(new Demultiplexer());
    }

    public static class Rig
    extends ExecutionRig {
        @Override
        public PrimaryContract execute() throws Exception {
            return this.execute(new BedDiffBlck());
        }
    }

    public class BedLdrMplxr
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            BedOverlap ov = (BedOverlap)bin.getPayload();
            bin.recycle();
            ContractGroup cg = new ContractGroup(c);
            ContractGroup.SiblingContract ref = cg.newContract(false);
            String refStem = (String)c.get(BedDiffBlck.STEM_1_KEY);
            ref.put(BedDiffBlck.BED_NUMBER, "1");
            ref.put("BimFamLoader.Stem", refStem);
            ref.put("BedConstants.OutBimList", ov.getBimIndex1());
            ref.put("BedConstants.OutFamList", ov.getFamIndex1());
            ref.put("gt_output_order", BedConstants.Order.SNP_MAJOR);
            BucketBase fb = new BucketBase();
            this.getProcessor().consume(ref, fb, endOfInput);
            ContractGroup.SiblingContract nov = cg.newContract(true);
            String novStem = (String)c.get(BedDiffBlck.STEM_2_KEY);
            nov.put(BedDiffBlck.BED_NUMBER, "2");
            nov.put("BimFamLoader.Stem", novStem);
            nov.put("BedConstants.OutBimList", ov.getBimIndex2());
            nov.put("BedConstants.OutFamList", ov.getFamIndex2());
            nov.put("gt_output_order", BedConstants.Order.SNP_MAJOR);
            BucketBase bb = new BucketBase();
            this.getProcessor().consume(nov, bb, endOfInput);
        }
    }

    public class BedMetadataLdrMplxr
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            ContractGroup cg = new ContractGroup(c);
            ContractGroup.SiblingContract ref = cg.newContract(false);
            String refStem = (String)c.get(BedDiffBlck.STEM_1_KEY);
            ref.put(BedDiffBlck.BED_NUMBER, "1");
            ref.put("BimFamLoader.Stem", refStem);
            BucketBase fb = new BucketBase();
            this.getProcessor().consume(ref, fb, endOfInput);
            ContractGroup.SiblingContract nov = cg.newContract(true);
            String novStem = (String)c.get(BedDiffBlck.STEM_2_KEY);
            nov.put(BedDiffBlck.BED_NUMBER, "2");
            nov.put("BimFamLoader.Stem", novStem);
            BucketBase bb = new BucketBase();
            this.getProcessor().consume(nov, bb, endOfInput);
            bin.recycle();
        }
    }
}

