/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped.rig;

import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Configurable;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Node;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.io.AsynchronousFileChannelReader;
import uk.ac.ox.well.t2d.async.io.BufferConfigurable;
import uk.ac.ox.well.t2d.async.io.PathFinder;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.metadata.MetadataWriter;
import uk.ac.ox.well.t2d.async.ped.BimFamLoader;

public class BedDataLoader
implements Node<Object, ByteBuffer>,
Configurable,
BufferConfigurable {
    protected int bucketCount = 3;
    protected int capacity = 20000;
    protected ExecutorService serv;
    protected BimFamLoader bfl = new BimFamLoader();
    protected BedMetadataWriter bmw = new BedMetadataWriter();
    protected BedStemReader pl = new BedStemReader();
    protected PathFinder pf = new PathFinder();
    protected AsynchronousFileChannelReader cr = new AsynchronousFileChannelReader();
    protected Processor<ByteBuffer> bp = null;

    @Override
    public void setBucketCount(int bc) {
        this.bucketCount = bc;
    }

    @Override
    public void setBufferCapacity(int c) {
        this.capacity = c;
    }

    @Override
    public void setExecutorService(ExecutorService es) {
        this.serv = es;
    }

    @Override
    public void commence() {
        this.bfl.setBucketCount(this.bucketCount);
        this.bmw.setBucketCount(this.bucketCount);
        this.pl.setBucketCount(this.bucketCount);
        this.pf.setBucketCount(this.bucketCount);
        this.cr.setBucketCount(this.bucketCount);
        this.bfl.setExecutorService(this.serv);
        this.bmw.setExecutorService(this.serv);
        this.pl.setExecutorService(this.serv);
        this.pf.setExecutorService(this.serv);
        this.cr.setExecutorService(this.serv);
        this.bfl.setProcessor(this.bmw);
        this.bmw.setProcessor(this.pl);
        this.pl.setProcessor(this.pf);
        this.pf.setProcessor(this.cr);
        if (null != this.bp) {
            this.cr.setProcessor(this.bp);
        }
        this.bfl.commence();
        this.pl.commence();
        this.bmw.commence();
        this.pf.commence();
        this.cr.commence();
        if (null != this.bp) {
            this.bp.commence();
        }
    }

    @Override
    public void close() {
        this.bfl.close();
        this.pl.close();
        this.pf.close();
        this.cr.close();
        if (null != this.bp) {
            this.bp.close();
        }
    }

    @Override
    public void consume(Contract c, Bucket bin, boolean endOfInput) {
        this.bfl.consume(c, bin, endOfInput);
    }

    @Override
    public void setProcessor(Processor<ByteBuffer> processor) {
        this.bp = processor;
        this.cr.setProcessor(processor);
    }

    public static class BedStemReader
    extends MetadataReader {
        public BedStemReader() {
            this.setPropertyKey("BimFamLoader.Stem");
        }

        @Override
        public Object processMetadata(Contract c, Object md) {
            String str = (String)md;
            return str + ".bed";
        }
    }

    public class BedMetadataWriter
    extends MetadataWriter {
        public BedMetadataWriter() {
            this.setPropertyKey("BedParsingContext.BedMetadataIn");
        }
    }
}

