/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped.rig;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Node;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.io.AsynchronousFileChannelWriter;
import uk.ac.ox.well.t2d.async.io.CharacterEncoder;
import uk.ac.ox.well.t2d.async.parser.ListWriter;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class CallMetricsRig
implements Node,
Processor {
    protected String suffixOut;
    protected int bucketCount = 3;
    protected int capacity = 20000;
    protected ExecutorService serv;
    protected AbstractConveyor metricsParser;
    protected ListWriter lw = new ListWriter();
    protected CharacterEncoder ce = new CharacterEncoder();
    protected OutputPathFormatter opf = new OutputPathFormatter();
    protected AsynchronousFileChannelWriter cw = new AsynchronousFileChannelWriter();

    public void setSuffixOut(String sfx) {
        this.suffixOut = sfx;
    }

    public void setBucketCount(int bc) {
        this.bucketCount = bc;
    }

    public void setBufferCapacity(int c) {
        this.capacity = c;
    }

    public void setExecutorService(ExecutorService es) {
        this.serv = es;
    }

    public void setMetricParser(AbstractConveyor ac) {
        this.metricsParser = ac;
    }

    @Override
    public void commence() {
        this.metricsParser.setBucketCount(this.bucketCount);
        this.lw.setBucketCount(this.bucketCount);
        this.ce.setBucketCount(this.bucketCount);
        this.cw.setBucketCount(this.bucketCount);
        this.metricsParser.setExecutorService(this.serv);
        this.lw.setExecutorService(this.serv);
        this.ce.setExecutorService(this.serv);
        this.cw.setExecutorService(this.serv);
        this.metricsParser.setProcessor(this.lw);
        this.lw.setProcessor(this.ce);
        this.ce.setProcessor(this.opf);
        this.opf.setProcessor((Processor)this.cw);
        this.metricsParser.commence();
        this.lw.commence();
        this.ce.commence();
        this.cw.commence();
    }

    @Override
    public void close() {
        this.metricsParser.close();
        this.lw.close();
        this.ce.close();
        this.cw.close();
    }

    public void consume(Contract c, Bucket bin, boolean endOfInput) {
        this.metricsParser.consume(c, bin, endOfInput);
    }

    public void setProcessor(Processor processor) {
        this.cw.setProcessor(processor);
    }

    public class OutputPathFormatter
    implements Node,
    Processor {
        Processor p;

        public void setProcessor(Processor processor) {
            this.p = processor;
        }

        @Override
        public void commence() {
        }

        @Override
        public void close() {
        }

        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            String s = (String)c.get("IOProperties.OUT_STEM");
            StringBuilder sb = new StringBuilder();
            sb.append(s);
            sb.append(".");
            sb.append(CallMetricsRig.this.suffixOut);
            Path path = Paths.get(sb.toString(), new String[0]);
            c.put("IOProperties.OUT_PATH", path);
            this.p.consume(c, bin, endOfInput);
        }
    }
}

