/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped.tools;

import java.nio.ByteBuffer;
import java.util.List;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.metadata.FileWrtrBlock;
import uk.ac.ox.well.t2d.async.metadata.PropertyReporter;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.parser.ListWriter;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedParsingContext;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;
import uk.ac.ox.well.t2d.async.ped.rig.BedDataLoader;
import uk.ac.ox.well.t2d.async.ped.tools.AlternateGenotype;
import uk.ac.ox.well.t2d.async.ped.tools.GenotypeIndex;
import uk.ac.ox.well.t2d.async.ped.tools.MinorAlleleGenotype;
import uk.ac.ox.well.t2d.async.ped.tools.MinorAlleleGenotypeLdrBlck;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;
import uk.ac.ox.well.t2d.async.taqman.rig.SeriesBlock;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class BedGenotypeFinder
extends AbstractConveyor<FinderContext, ByteBuffer, List> {
    public BedGenotypeFinder() {
        this.setPayloadManager(new CollectionFactory.ListFactory().setReuse(false));
    }

    @Override
    protected FinderContext newContext() {
        return new FinderContext();
    }

    public static class Rig
    extends ExecutionRig {
        @Override
        public PrimaryContract execute() throws Exception {
            SeriesBlock sb = new SeriesBlock();
            sb.addProcessor(new MinorAlleleGenotypeLdrBlck());
            sb.addProcessor(new PropertyReporter.CollectionRprtr().setIsRequired(true).setKey("MinorAlleleGenotype.List").setLabel("MinorAlleleReport"));
            sb.addProcessor(new MinorAlleleGenotypeLdrBlck.MinorAlleleGenotypeIndexer());
            sb.addProcessor(new BedDataLoader());
            sb.addProcessor(new BedGenotypeFinder());
            sb.addProcessor(new ListWriter());
            sb.addProcessor(new FileWrtrBlock.CharWrtr());
            return this.execute(sb);
        }
    }

    public class FinderContext
    extends BedParsingContext<List> {
        GenotypeIndex idx;
        List<MinorAlleleGenotype> magl;

        @Override
        public void initialize() throws Exception {
            super.initialize();
            this.idx = (GenotypeIndex)this.getContract().get("MinorAlleleGenotype.Index");
            if (null == this.idx) {
                throw new RequiredPropertyValueNotFound("MinorAlleleGenotype.Index");
            }
            this.magl = (List)this.getContract().get("MinorAlleleGenotype.List");
            if (null == this.magl) {
                throw new RequiredPropertyValueNotFound("MinorAlleleGenotype.List");
            }
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, Bucket<List> po, boolean endOfContract) throws Exception {
            while (pi.hasRemaining()) {
                this.handleByte(pi.get());
            }
            if (endOfContract) {
                this.outerJoin(po.getPayload());
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }

        @Override
        public void handleCall(int snpIndex, int sampleIndex, BedConstants.Call call) {
            List altList = (List)this.getPayloadOut().getPayload();
            BimEntry bim = this.meta.getBimList().get(snpIndex);
            FamEntry fam = this.meta.getFamList().get(sampleIndex);
            MinorAlleleGenotype mag = (MinorAlleleGenotype)this.idx.get(bim.getChromosome(), bim.getPosition(), fam.getIndividualId());
            if (null != mag) {
                String gt = bim.toString(call).replace(" ", "");
                String snpId = bim.getSnpId();
                AlternateGenotype ag = new AlternateGenotype(mag, gt, snpId);
                altList.add(ag);
            }
        }

        public void outerJoin(List po) {
            AlternateGenotype ag;
            GenotypeIndex gi = new GenotypeIndex();
            for (Object o : po) {
                ag = (AlternateGenotype)o;
                gi.put(ag.getChr(), ag.getPos(), ag.getIndId(), ag);
            }
            po.clear();
            po.add(new AlternateGenotype.Header());
            for (MinorAlleleGenotype mag : this.magl) {
                ag = (AlternateGenotype)gi.get(mag.getChr(), mag.getPos(), mag.getIndId());
                if (null == ag) {
                    ag = new AlternateGenotype(mag, ".", ".");
                }
                po.add(ag);
            }
        }
    }
}

