/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped.tools;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.io.AsynchronousFileChannelReader;
import uk.ac.ox.well.t2d.async.io.PathFinder;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.parser.rig.ListWriterBlock;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedParsingContext;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;
import uk.ac.ox.well.t2d.async.ped.SnpMetrics;
import uk.ac.ox.well.t2d.async.ped.rig.BedDataLoader;
import uk.ac.ox.well.t2d.async.ped.tools.MinorAlleleGenotype;
import uk.ac.ox.well.t2d.async.ped.tools.SnpMetricsMetadataLdr;
import uk.ac.ox.well.t2d.async.ped.tools.SnpSetLdr;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;
import uk.ac.ox.well.t2d.async.taqman.rig.SeriesBlock;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class MinorAlleleGenotypeRetriever
extends SeriesBlock {
    public static final String SNP_METRICS_MAP = "SnpMetricsMap";

    @Override
    public void commence() {
        SnpSetLdr ldr = new SnpSetLdr();
        ldr.getMetadataReader().setIsRequired(true);
        this.addProcessor(ldr);
        SnpMetricsMetadataLdr snpMetaLdr = new SnpMetricsMetadataLdr();
        this.addProcessor(snpMetaLdr);
        SnpMetricsMapper mppr = new SnpMetricsMapper();
        this.addProcessor(mppr);
        this.addProcessor(new BedDataLoader.BedStemReader());
        this.addProcessor(new PathFinder());
        this.addProcessor(new AsynchronousFileChannelReader());
        BedParser bp = new BedParser();
        this.addProcessor(bp);
        ListWriterBlock lwb = new ListWriterBlock();
        this.addProcessor(lwb);
        super.commence();
    }

    public static class SnpMetricsMapper
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            HashMap<String, SnpMetrics> map = (HashMap<String, SnpMetrics>)c.get(MinorAlleleGenotypeRetriever.SNP_METRICS_MAP);
            if (null == map) {
                map = new HashMap<String, SnpMetrics>();
                List sml = (List)c.get("SnpMetricsList");
                if (null == sml) {
                    throw new RequiredPropertyValueNotFound("SnpMetricsList");
                }
                Set snps = (Set)c.get("SnpInclusionSet");
                if (null == snps) {
                    throw new RequiredPropertyValueNotFound("SnpInclusionSet");
                }
                for (SnpMetrics met : sml) {
                    if (!snps.contains(met.getBimEntry().getSnpId())) continue;
                    map.put(met.getBimEntry().getSnpId(), met);
                }
                c.put(MinorAlleleGenotypeRetriever.SNP_METRICS_MAP, map);
            }
            this.getProcessor().consume(c, bin, endOfInput);
        }
    }

    public class BedContext
    extends BedParsingContext<List<MinorAlleleGenotype>> {
        protected Map<String, SnpMetrics> snpMap;

        @Override
        public void initialize() throws Exception {
            super.initialize();
            this.snpMap = (Map)this.getContract().get(MinorAlleleGenotypeRetriever.SNP_METRICS_MAP);
            if (null == this.snpMap) {
                throw new RequiredPropertyValueNotFound(MinorAlleleGenotypeRetriever.SNP_METRICS_MAP);
            }
        }

        @Override
        public void clear() {
            this.snpMap = null;
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, Bucket<List<MinorAlleleGenotype>> po, boolean endOfContract) throws Exception {
            while (pi.hasRemaining()) {
                this.handleByte(pi.get());
            }
            if (endOfContract) {
                po.getPayload().add(0, new MinorAlleleGenotype.Header());
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }

        @Override
        public void handleCall(int snpIndex, int sampleIndex, BedConstants.Call call) {
            BimEntry bim = this.meta.getBimList().get(snpIndex);
            FamEntry fam = this.meta.getFamList().get(sampleIndex);
            SnpMetrics met = this.snpMap.get(bim.getSnpId());
            if (null != met) {
                if (BedConstants.Call.HET == call) {
                    this.handleHet(met, fam, call);
                } else if (BedConstants.Call.HOM1 == call || BedConstants.Call.HOM2 == call) {
                    this.handleHom(met, fam, call);
                }
            }
        }

        public void handleHom(SnpMetrics met, FamEntry fam, BedConstants.Call call) {
            if (BedConstants.Call.HOM1 == call && -1 == met.getMinorHomozygote()) {
                this.handleMinorHom(met, fam, met.getBimEntry().getAllele1());
            } else if (BedConstants.Call.HOM2 == call && 1 == met.getMinorHomozygote()) {
                this.handleMinorHom(met, fam, met.getBimEntry().getAllele2());
            }
        }

        public void handleMinorHom(SnpMetrics met, FamEntry fam, String allele) {
            MinorAlleleGenotype mae = this.newEntry(met, fam);
            mae.setGenotype(allele + allele);
            ((List)this.getPayloadOut().getPayload()).add(mae);
        }

        public void handleHet(SnpMetrics met, FamEntry fam, BedConstants.Call call) {
            MinorAlleleGenotype mae = this.newEntry(met, fam);
            mae.setGenotype(mae.getMinAllele() + mae.getMajAllele());
            ((List)this.getPayloadOut().getPayload()).add(mae);
        }

        public MinorAlleleGenotype newEntry(SnpMetrics met, FamEntry fam) {
            MinorAlleleGenotype mae = new MinorAlleleGenotype();
            mae.setSnpId(met.getBimEntry().getSnpId());
            mae.setChr(met.getBimEntry().getChromosome());
            mae.setPos(met.getBimEntry().getPosition());
            String[] oa = met.getOrderedAlleles();
            mae.setMinAllele(oa[0]);
            mae.setMajAllele(oa[1]);
            mae.setMinorAlleleCount(Integer.toString(met.getMinorAlleleCount()));
            mae.setIndId(fam.getIndividualId());
            mae.setFamId(fam.getFamilyId());
            return mae;
        }
    }

    public class BedParser
    extends AbstractConveyor<BedContext, ByteBuffer, List<MinorAlleleGenotype>> {
        public BedParser() {
            this.setPayloadManager(new CollectionFactory.ListFactory().setReuse(false));
        }

        @Override
        protected BedContext newContext() {
            return new BedContext();
        }
    }

    public static class Rig
    extends ExecutionRig {
        @Override
        public PrimaryContract execute() throws Exception {
            SeriesBlock sb = new SeriesBlock();
            sb.addProcessor(new MinorAlleleGenotypeRetriever());
            return this.execute(sb);
        }
    }
}

