/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.processors;

import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Command;
import uk.ac.ox.well.t2d.async.Configurable;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Node;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.processors.BucketBase;
import uk.ac.ox.well.t2d.async.processors.BucketManager;
import uk.ac.ox.well.t2d.async.processors.CommandQueue;
import uk.ac.ox.well.t2d.async.processors.ContextManager;
import uk.ac.ox.well.t2d.async.processors.NullPayloadManager;
import uk.ac.ox.well.t2d.async.processors.PayloadManager;
import uk.ac.ox.well.t2d.async.processors.SerialCommandQueue;

public abstract class AbstractConveyor<CX extends ProcessingContext<PI, PO>, PI, PO>
implements Node<PI, PO>,
Configurable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ExecutorService executor;
    protected int bucketCount;
    protected Processor<PO> processor;
    protected PayloadManager<PO> payloadManager;
    protected ProcessingContextManager contextManager;
    protected BucketManager bucketManager;
    protected CommandQueue<PI> commandQueue;

    public AbstractConveyor() {
        this(new SerialCommandQueue());
    }

    public AbstractConveyor(CommandQueue<PI> q) {
        this.commandQueue = q;
        this.bucketManager = new BucketManager();
        this.contextManager = new ProcessingContextManager();
        this.payloadManager = new NullPayloadManager();
        this.bucketCount = 1;
    }

    public CommandQueue<PI> getCommandQueue() {
        return this.commandQueue;
    }

    public void setCommandQueue(CommandQueue<PI> q) {
        this.commandQueue = q;
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public void setBucketCount(int bucketCount) {
        this.bucketCount = bucketCount;
    }

    @Override
    public void setProcessor(Processor<PO> processor) {
        this.processor = processor;
    }

    public PayloadManager<PO> getPayloadManager() {
        return this.payloadManager;
    }

    public void setPayloadManager(PayloadManager<PO> factory) {
        this.payloadManager = factory;
    }

    @Override
    public void commence() {
        for (int i = 0; i < this.bucketCount; ++i) {
            Bucket<PO> bkt = this.newBucket();
            PO payload = this.payloadManager.newPayload();
            bkt.setPayload(payload);
            this.bucketManager.add(bkt);
        }
    }

    @Override
    public void close() {
        for (Bucket b : this.bucketManager.getBuckets()) {
            Object po = b.getPayload();
            this.payloadManager.closePayload(po);
        }
    }

    @Override
    public void consume(Contract c, Bucket<PI> b, boolean endOfInput) {
        if (!endOfInput) {
            this.commandAdd(new Command<PI>(Command.Type.CONSUME, c, b));
        } else {
            this.commandAdd(new Command<PI>(Command.Type.COMPLETE, c, b));
        }
        this.prompt();
    }

    public void prompt() {
        ExecutorRunnable runnable;
        while (null != (runnable = this.poll())) {
            this.execute(runnable);
        }
    }

    protected void execute(Runnable r) {
        this.executor.execute(r);
    }

    protected synchronized ExecutorRunnable poll() {
        Command<PI> cmd = this.commandPoll();
        if (null == cmd) {
            return null;
        }
        CX cxt = this.getContext(cmd.getContract());
        if (null == ((ProcessingContext)cxt).getPayloadOut()) {
            Bucket<PO> bkt = this.pollBucket(cmd.getContract());
            ((ProcessingContext)cxt).setPayloadOut(bkt);
        }
        if (null == ((ProcessingContext)cxt).getPayloadOut()) {
            this.commandAddFirst(cmd);
            return null;
        }
        ((ProcessingContext)cxt).setCommand(cmd);
        ExecutorRunnable runnable = new ExecutorRunnable(this, cxt);
        return runnable;
    }

    protected Bucket<PO> pollBucket(Contract c) {
        Bucket bkt = this.bucketManager.poll(c);
        return bkt;
    }

    protected synchronized void recycleBucket(BucketImpl impl) {
        impl.setPayload(this.payloadManager.resetPayload(impl.getPayload()));
        this.bucketManager.replace(impl);
    }

    public synchronized Command<PI> commandPoll() {
        return this.commandQueue.poll();
    }

    public synchronized void commandAdd(Command<PI> cmd) {
        this.commandQueue.queue(cmd);
    }

    public synchronized void commandAddFirst(Command<PI> cmd) {
        this.commandQueue.requeue(cmd);
    }

    public synchronized void commandComplete(Command<PI> cmd) {
        this.commandQueue.complete(cmd);
    }

    protected abstract CX newContext();

    protected CX getContext(Contract c) {
        if (null != this.contextManager) {
            return (CX)((ProcessingContext)this.contextManager.getContext(c));
        }
        throw new NullPointerException("ContextManager has not been set");
    }

    protected synchronized void removeContext(Contract c) {
        if (null == this.contextManager) {
            throw new NullPointerException("ContextManager has not been set");
        }
        this.contextManager.removeContext(c);
        this.bucketManager.setFullyAssigned(c);
    }

    protected void process(CX cxt) {
        ((ProcessingContext)cxt).run();
        ProcessingResult result = ((ProcessingContext)cxt).getResult();
        this.processingCompleted(result, cxt);
    }

    protected void processingCompleted(ProcessingResult result, CX context) {
        boolean isFinalOutput;
        if (ProcessingResult.NEITHER_COMPLETE.equals((Object)result)) {
            return;
        }
        boolean bl = isFinalOutput = ((ProcessingContext)context).isEndOfContract() && result.isInputComplete();
        if (result.isOutputComplete()) {
            this.processOutput(context, isFinalOutput);
        }
        if (result.isInputComplete()) {
            ((ProcessingContext)context).getPayloadIn().recycle();
            this.commandComplete(((ProcessingContext)context).getCommand());
        } else {
            this.commandAddFirst(((ProcessingContext)context).getCommand());
        }
        if (result.isFailure()) {
            ((ProcessingContext)context).getPayloadIn().recycle();
            ((ProcessingContext)context).getPayloadOut().recycle();
            ((ProcessingContext)context).setPayloadOut(null);
            this.removeContext(((ProcessingContext)context).getContract());
        }
        if (isFinalOutput) {
            this.removeContext(((ProcessingContext)context).getContract());
        }
        this.prompt();
    }

    protected void processingFailed(CX context, Throwable thr) {
        ((ProcessingContext)context).getContract().fail(thr);
        this.processingCompleted(ProcessingResult.FAILURE, context);
    }

    protected void processOutput(CX context, boolean endOfStream) {
        this.processor.consume(((ProcessingContext)context).getContract(), ((ProcessingContext)context).getPayloadOut(), endOfStream);
        ((ProcessingContext)context).setPayloadOut(null);
    }

    protected Bucket<PO> newBucket() {
        BucketImpl bi = new BucketImpl();
        return bi;
    }

    public class ProcessingContextManager
    extends ContextManager<CX> {
        @Override
        protected CX newContext(Contract c) {
            return AbstractConveyor.this.newContext();
        }

        @Override
        protected void clearContext(CX context) {
            ((ProcessingContext)context).clear();
        }
    }

    public static class ExecutorRunnable
    implements Runnable {
        CX cxt;
        final /* synthetic */ AbstractConveyor this$0;

        public ExecutorRunnable(CX processingContext) {
            this.this$0 = var1_1;
            this.cxt = processingContext;
        }

        @Override
        public void run() {
            this.this$0.process(this.cxt);
        }
    }

    protected class BucketImpl
    extends BucketBase<PO> {
        protected BucketImpl() {
        }

        @Override
        public void recycle() {
            AbstractConveyor.this.recycleBucket(this);
            AbstractConveyor.this.prompt();
        }
    }
}

