/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;

public class BucketManager {
    protected List<Bucket> buckets = new ArrayList<Bucket>();
    protected Queue<Bucket> free = new ConcurrentLinkedQueue<Bucket>();
    protected LinkedHashMap<Contract, Context> contextMap = new LinkedHashMap();
    protected LinkedHashMap<Bucket, Contract> bucketMap = new LinkedHashMap();

    public void add(Bucket b) {
        this.buckets.add(b);
        this.free.add(b);
    }

    public Bucket poll(Contract c) {
        Context cxt = this.getContext(c);
        Bucket b = cxt.poll();
        if (null == b && null != (b = this.free.poll())) {
            cxt.assign(b);
            this.bucketMap.put(b, c);
        }
        return b;
    }

    public void replace(Bucket bkt) {
        Contract c = this.bucketMap.get(bkt);
        Context cxt = this.getContext(c);
        cxt.replace(bkt);
        if (cxt.isComplete()) {
            this.removeContext(c);
        }
    }

    public void setFullyAssigned(Contract c) {
        Context cxt = this.getContext(c);
        cxt.setFullyAssigned();
        if (cxt.isComplete()) {
            this.removeContext(c);
        }
    }

    public Collection<Bucket> getBuckets() {
        return this.buckets;
    }

    public void removeContext(Contract c) {
        Context cxt = (Context)this.contextMap.remove(c);
        if (null != cxt) {
            for (Bucket b : cxt.assigned) {
                this.bucketMap.remove(b);
            }
            this.free.addAll(cxt.assigned);
        }
    }

    public Context getContext(Contract c) {
        Context cxt = this.contextMap.get(c);
        if (null == cxt) {
            cxt = new Context();
            this.contextMap.put(c, cxt);
        }
        return cxt;
    }

    public class Context {
        protected boolean fullyAssigned = false;
        protected LinkedHashSet<Bucket> assigned = new LinkedHashSet();
        protected ConcurrentLinkedQueue<Bucket> available = new ConcurrentLinkedQueue();

        public void reset() {
            this.fullyAssigned = false;
            this.assigned.clear();
            this.available.clear();
        }

        public Bucket poll() {
            return this.available.poll();
        }

        public void assign(Bucket bkt) {
            this.assigned.add(bkt);
        }

        public void replace(Bucket bkt) {
            if (!this.assigned.contains(bkt)) {
                throw new RuntimeException("Bucket returned to incorrect Contract.");
            }
            this.available.add(bkt);
        }

        public void setFullyAssigned() {
            this.fullyAssigned = true;
        }

        public boolean isFullyAssigned() {
            return this.fullyAssigned;
        }

        public boolean isAllPresent() {
            return this.assigned.size() <= this.available.size();
        }

        public boolean isComplete() {
            return this.isFullyAssigned() && this.isAllPresent();
        }
    }
}

