/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.processors;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.processors.BucketBase;

public abstract class BucketMulticaster<PI, PO>
implements Iterable<Bucket<PO>> {
    protected Bucket<PI> parent;
    protected Set<Bucket<PO>> children;
    protected Set<ChildBucket> returnedChildren;
    protected boolean isFinalized;

    public BucketMulticaster(Bucket<PI> b) {
        this.parent = b;
        this.children = new LinkedHashSet<Bucket<PO>>();
        this.returnedChildren = new HashSet<ChildBucket>();
        this.isFinalized = false;
    }

    @Override
    public Iterator<Bucket<PO>> iterator() {
        return this.children.iterator();
    }

    protected void recycleParent() {
        this.parent.recycle();
    }

    protected synchronized void recycleChild(ChildBucket cb) {
        if (!this.children.contains(cb)) {
            throw new RuntimeException("Returning 'child' bucket not known!");
        }
        this.returnedChildren.add(cb);
        if (this.isFinalized && this.returnedChildren.size() >= this.children.size()) {
            this.recycleParent();
        }
    }

    protected class ChildBucket
    extends BucketBase<PO> {
        public ChildBucket(PO p) {
            super(p);
        }

        @Override
        public void recycle() {
            BucketMulticaster.this.recycleChild(this);
        }
    }
}

