/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.processors;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class CollectionSerializer<P>
extends AbstractConveyor<CollectionSerializerContext<P>, Collection<P>, P> {
    @Override
    protected CollectionSerializerContext newContext() {
        return new CollectionSerializerContext();
    }

    public static class CollectionSerializerContext<P>
    extends ProcessingContext<Collection<P>, P> {
        Queue<P> q = new LinkedList<P>();

        @Override
        public void clear() {
            super.clear();
            this.q.clear();
        }

        @Override
        public ProcessingResult process(Collection<P> pi, Bucket<P> bo, boolean endOfContract) throws Exception {
            if (pi.isEmpty()) {
                throw new RuntimeException("Currently, input lists cannot be empty.");
            }
            if (this.q.isEmpty()) {
                this.q.addAll(pi);
            }
            bo.setPayload(this.q.remove());
            if (this.q.isEmpty()) {
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.OUTPUT_COMPLETE;
        }
    }
}

