/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.processors;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.well.t2d.async.Command;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.processors.CommandQueue;

public class SerialCommandQueue<PI>
implements CommandQueue<PI> {
    protected Set<Contract> currentlyExecuting = new HashSet<Contract>();
    protected LinkedHashMap<Contract, Deque<Command>> qMap = new LinkedHashMap();
    protected int depth = 0;

    public void setDepth(int i) {
        this.depth = i;
    }

    @Override
    public synchronized Command<PI> poll() {
        for (Map.Entry<Contract, Deque<Command>> e : this.qMap.entrySet()) {
            if (this.currentlyExecuting.contains(e.getKey()) || e.getValue().isEmpty()) continue;
            this.currentlyExecuting.add(e.getKey());
            Command cmd = e.getValue().remove();
            return cmd;
        }
        return null;
    }

    @Override
    public synchronized void queue(Command<PI> cmd) {
        Deque<Command> q = this.getDeque(cmd);
        q.add(cmd);
    }

    @Override
    public synchronized void requeue(Command<PI> cmd) {
        Deque<Command> q = this.getDeque(cmd);
        q.addFirst(cmd);
        this.currentlyExecuting.remove(this.getContract(cmd));
    }

    @Override
    public synchronized void complete(Command<PI> cmd) {
        this.currentlyExecuting.remove(this.getContract(cmd));
        if (Command.Type.COMPLETE.equals((Object)cmd.getType()) && this.qMap.isEmpty()) {
            this.removeCommand(cmd);
        }
    }

    protected void removeCommand(Command<PI> cmd) {
        this.qMap.remove(this.getContract(cmd));
    }

    protected Deque<Command> getDeque(Command<PI> cmd) {
        Deque<Command> q = this.qMap.get(this.getContract(cmd));
        if (null == q) {
            q = this.newDeque();
            this.qMap.put(this.getContract(cmd), q);
        }
        return q;
    }

    protected Deque<Command> newDeque() {
        return new LinkedList<Command>();
    }

    protected Contract getContract(Command<PI> cmd) {
        Contract thisContract = cmd.getContract();
        for (int i = 0; i < this.depth; ++i) {
            if (null == thisContract.getSuperContract()) {
                throw new RuntimeException("Queue Contract Depth set to " + this.depth + ". However there were not enough ancestor Contracts to " + "satisfy that requirement. Failed at depth " + i + ".");
            }
            thisContract = thisContract.getSuperContract();
        }
        return thisContract;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SerialQueue: ").append(this.currentlyExecuting).append("\n");
        for (Map.Entry<Contract, Deque<Command>> e : this.qMap.entrySet()) {
            sb.append(e.getKey()).append(" Count: ").append(e.getValue().size()).append("\n");
        }
        return sb.toString();
    }
}

