/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.projects.dare;

import java.nio.file.Path;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class DareListTransformer
extends AbstractConveyor<Context, List, List> {
    public static final String TUBE_RACK_BARCODE_KEY = "DareListTransformer.TubeRackBarcode";
    public static final Pattern PREFIX_PATTERN = Pattern.compile("^(\\w*)-(\\w*)-(\\w*)");
    public static final Pattern BARCODE_PATTERN = Pattern.compile("(\\d*)\\s+(\\d*)\\s+(\\d*)\\.\\w+$");
    public static final String TUBE_RACK_PRODUCT_TYPE = "FLUIDX_1_4";

    public DareListTransformer() {
        this.setPayloadManager(new CollectionFactory.ListFactory().setReuse(false));
    }

    @Override
    protected Context newContext() {
        return new Context();
    }

    public String formatEntry(String tubeBarcode, String tubePos, String prefix, int iid, String alqt, String boxBarcode, String boxName) {
        Formatter f = new Formatter();
        f.format("%s\tDARE-TV-%s%03d-AA\t%s\t%s\t0\t%s\t%s\t%s", tubeBarcode, prefix, iid, tubePos, alqt, boxBarcode, boxName, TUBE_RACK_PRODUCT_TYPE);
        return f.toString();
    }

    public static String[] capturePrefixComponents(String pathName) {
        Matcher m = PREFIX_PATTERN.matcher(pathName);
        m.find();
        String[] array = new String[]{m.group(1), m.group(2), m.group(3)};
        return array;
    }

    public static String[] captureBarcodeComponents(String pathName) {
        Matcher m = BARCODE_PATTERN.matcher(pathName);
        m.find();
        String[] array = new String[]{m.group(1), m.group(2), m.group(3)};
        return array;
    }

    public class Context
    extends ProcessingContext<List, List> {
        public Path path;
        public String prefix;
        public int startAt;
        public String boxBarcode;
        public String boxName;

        @Override
        public void initialize() {
            this.path = (Path)this.getContract().get("IOProperties.IN_PATH");
            if (null == this.path) {
                throw new RequiredPropertyValueNotFound("IOProperties.IN_PATH");
            }
            String fileName = this.path.getFileName().toString();
            this.capturePrefixComponent(fileName);
            this.captureBarcodeComponent(fileName);
            DareListTransformer.this.logger.info("Found TubeRackScan File at Path: '" + this.path + "'");
            DareListTransformer.this.logger.info(new Formatter().format("Extracted TubeRackBarcode %s, CentrePrefix %s, StartingAt %03d", this.boxBarcode, this.prefix, this.startAt).toString());
            this.getContract().put(DareListTransformer.TUBE_RACK_BARCODE_KEY, this.boxBarcode);
        }

        protected void capturePrefixComponent(String pathName) {
            String[] pts = DareListTransformer.capturePrefixComponents(pathName);
            this.prefix = pts[0];
            this.startAt = Integer.parseInt(pts[1]);
            int end = Integer.parseInt(pts[2]);
            if (this.startAt != end - 5) {
                throw new RuntimeException("The Prefix end number is not 5 less than the start number. Found " + pts[1] + " and " + pts[2] + " at Path: " + this.path);
            }
            Formatter f = new Formatter();
            this.boxName = f.format("DARE-TV-%s-%03d-%03d", this.prefix, this.startAt, this.startAt + 5).toString();
        }

        protected void captureBarcodeComponent(String pathName) {
            this.boxBarcode = DareListTransformer.captureBarcodeComponents(pathName)[0];
        }

        @Override
        public ProcessingResult process(List pi, List po, boolean endOfContract) {
            if (96 != pi.size()) {
                throw new RuntimeException("Each TubeRackScan should have 96 entries. Found " + pi.size() + " in Path: " + this.path);
            }
            this.generateSixIndividuals(pi, po);
            return ProcessingResult.BOTH_COMPLETE;
        }

        public void generateSixIndividuals(List pi, List po) {
            Iterator it = pi.iterator();
            for (int i = 0; i < 6; ++i) {
                this.generateSixteenTubeEntriesPerIndividual(this.startAt + i, it, po);
            }
        }

        public void generateSixteenTubeEntriesPerIndividual(int indId, Iterator it, List results) {
            int i;
            for (i = 0; i < 8; ++i) {
                this.generateEntry(indId, "ePla-" + (i + 1), it, results);
            }
            for (i = 0; i < 8; ++i) {
                this.generateEntry(indId, "URI-" + (i + 1), it, results);
            }
        }

        public void generateEntry(int iid, String alqt, Iterator it, List results) {
            String[] strs = (String[])it.next();
            String entry = DareListTransformer.this.formatEntry(strs[1], strs[0], this.prefix, iid, alqt, this.boxBarcode, this.boxName);
            results.add(entry);
        }
    }
}

