/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.projects.dare;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.ContractGroup;
import uk.ac.ox.well.t2d.async.contracts.Demultiplexer;
import uk.ac.ox.well.t2d.async.contracts.ParallelMultiplexer;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.contracts.Resequencer;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.io.PathScanner;
import uk.ac.ox.well.t2d.async.metadata.FileLdrBlock;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.metadata.PropertyDeletor;
import uk.ac.ox.well.t2d.async.metadata.PropertyInjector;
import uk.ac.ox.well.t2d.async.metadata.PropertyWriter;
import uk.ac.ox.well.t2d.async.parser.StringArrayParser;
import uk.ac.ox.well.t2d.async.parser.rig.Bypass;
import uk.ac.ox.well.t2d.async.parser.rig.ListWriterBlock;
import uk.ac.ox.well.t2d.async.parser.rig.OutputPathBuilder;
import uk.ac.ox.well.t2d.async.processors.BucketBase;
import uk.ac.ox.well.t2d.async.processors.CollectionSerializer;
import uk.ac.ox.well.t2d.async.processors.PayloadReporter;
import uk.ac.ox.well.t2d.async.projects.dare.DareListTransformer;
import uk.ac.ox.well.t2d.async.projects.dare.EmptyCollectionBypass;
import uk.ac.ox.well.t2d.async.projects.dare.InputDirectoryOutputStemBuilder;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class DareSampleSheetBuilderBlck
extends SubSection {
    public static final String TUBE_RACK_PATHS_KEY = "DareSampleSheetBuilderBlck.TubeRackPaths";
    public static final String TUBE_RACK_BARCODES_KEY = "DareSampleSheetBuilderBlck.TubeRackBarcodes";
    protected static final String CSV_FILE_PATTERN = "glob:**.csv";

    public DareSampleSheetBuilderBlck() {
        this.addProcessor(new PayloadReporter("Scanning Input Directory"));
        this.addProcessor(new PropertyWriter().setKey("IOProperties.IN_DIRECTORY"));
        this.addProcessor(new InputDirectoryOutputStemBuilder());
        this.addProcessor(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("BatchTubeRackManifest.txt"));
        this.addProcessor(new OutputPathBuilder());
        OutputFileExistsBypass ofeBypass = new OutputFileExistsBypass();
        this.addProcessor(ofeBypass);
        ofeBypass.setBypassProcessor(this.tail);
        PathScanner scanner = new PathScanner();
        scanner.addPattern(CSV_FILE_PATTERN);
        scanner.setMaxDepth(1);
        this.addProcessor(scanner);
        EmptyCollectionBypass epBypass = new EmptyCollectionBypass().setMessage("No Csv Files Found.");
        this.addProcessor(epBypass);
        this.addProcessor(new PropertyWriter().setKey(TUBE_RACK_PATHS_KEY));
        this.addProcessor(new CollectionSerializer());
        this.addProcessor(new ParallelMultiplexer());
        FileLdrBlock.Character csvFileLoader = new FileLdrBlock.Character();
        csvFileLoader.getPathFinder().setDepth(1);
        this.addProcessor(csvFileLoader);
        this.addProcessor(new StringArrayParser.CommaCsvStringArrayParser());
        this.addProcessor(new DareListTransformer());
        this.addProcessor(new HeaderPutter());
        this.addProcessor(new RackBarcodesCollector());
        this.addProcessor(new Resequencer());
        this.addProcessor(new Demultiplexer());
        this.addProcessor(new ListWriterBlock());
        BlckReporter brep = new BlckReporter();
        this.addProcessor(brep);
        epBypass.setBypassProcessor(brep);
        this.addProcessor(new PropertyDeletor().setKey("IOProperties.OUT_PATH"));
        this.addProcessor(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("BatchTubeRackManifest.log"));
        this.addProcessor(new ListWriterBlock());
    }

    public static class BlckReporter
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            ArrayList<String> msgs = new ArrayList<String>();
            msgs.add("Completed DARE Manifest Build, " + new Date());
            msgs.add("Reading from Input Directory: " + c.get("IOProperties.IN_DIRECTORY"));
            List paths = (List)c.get(DareSampleSheetBuilderBlck.TUBE_RACK_PATHS_KEY);
            if (null == paths) {
                paths = Collections.EMPTY_LIST;
                msgs.add("WARNING: No Csv Files were found.");
            }
            msgs.add("Found " + paths.size() + " TubeRack Csv Files.");
            List barcodes = (List)c.get(DareSampleSheetBuilderBlck.TUBE_RACK_BARCODES_KEY);
            if (null == barcodes) {
                barcodes = Collections.EMPTY_LIST;
            }
            HashSet bs = new HashSet();
            HashSet dups = new HashSet();
            for (Object o : barcodes) {
                if (bs.contains(o)) {
                    dups.add(o);
                    continue;
                }
                bs.add(o);
            }
            if (dups.isEmpty()) {
                msgs.add("Found " + bs.size() + " unique Tube Rack barcodes.");
            } else {
                int dupCount = 0;
                for (Object o : barcodes) {
                    if (!dups.contains(o)) continue;
                    ++dupCount;
                }
                msgs.add("WARNING: Found " + dups.size() + " duplicate Tube Rack barcode(s) " + dups + ". " + dupCount + " TubeRack Csv Files use these duplicates barcode(s).");
            }
            msgs.add("Outputting Batch Manifest to Path: " + c.get("IOProperties.OUT_PATH"));
            BucketBase<ArrayList<String>> bb = new BucketBase<ArrayList<String>>();
            bb.setPayload(msgs);
            this.getProcessor().consume(c, bb, endOfInput);
        }
    }

    public static class RackBarcodesCollector
    extends BasicProcessor {
        @Override
        public synchronized void consume(Contract c, Bucket bin, boolean endOfInput) {
            String barcode = (String)c.get("DareListTransformer.TubeRackBarcode");
            ArrayList<String> l = (ArrayList<String>)c.getSuperContract().get(DareSampleSheetBuilderBlck.TUBE_RACK_BARCODES_KEY);
            if (null == l) {
                l = new ArrayList<String>();
                c.getSuperContract().put(DareSampleSheetBuilderBlck.TUBE_RACK_BARCODES_KEY, l);
            }
            l.add(barcode);
            this.getProcessor().consume(c, bin, endOfInput);
        }
    }

    public static class HeaderPutter
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            ContractGroup.SiblingContract sc = (ContractGroup.SiblingContract)c;
            if (0 == sc.getIndex()) {
                List l = (List)bin.getPayload();
                l.add(0, "Barcode\tSampleId\tPosition\tAliquot\tVolume\tRackBarcode\tRackName\tRackProductType");
            }
            this.getProcessor().consume(c, bin, endOfInput);
        }
    }

    public static class OutputFileExistsBypass
    extends Bypass {
        @Override
        protected boolean bypassRequired(Contract c, Bucket bin, boolean endOfInput) {
            Path opp;
            String op = (String)c.get("IOProperties.OUT_PATH");
            if (null != op && Files.exists(opp = Paths.get(op, new String[0]), new LinkOption[0])) {
                this.logger.info("Output file '" + opp + "' already exists. Exiting immediately.");
                return true;
            }
            return false;
        }
    }

    public static class Rig
    extends ExecutionRig {
        SubSection blck = new SubSection();

        public Rig() {
            this.blck.addProcessor(new MetadataReader().setIsRequired(true).setPropertyKey("IOProperties.IN_DIRECTORY"));
            this.blck.addProcessor(new DareSampleSheetBuilderBlck());
        }

        @Override
        public PrimaryContract execute() throws Exception {
            return this.execute(this.blck);
        }
    }
}

