/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.prototype.ver0;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.prototype.ver1.ExecutionManager;
import uk.ac.ox.well.t2d.async.prototype.ver1.TaskStatus;

public abstract class ChannelReaderService {
    Logger logger = Logger.getLogger(this.getClass().getName());
    ReadableByteChannel channel;
    ExecutionManager exe;
    Processor<ByteBuffer> sink;

    public ChannelReaderService(int bufferCount, int bufferCapacity, boolean directBuffer) {
    }

    public void setSink(Processor<ByteBuffer> s) {
        this.sink = s;
    }

    public void setExecutionManager(ExecutionManager em) {
        this.exe = em;
    }

    public void initialize() {
    }

    public void commence() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void consume(ReadableByteChannel o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void complete() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cancel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TaskStatus read(ByteBuffer bb) {
        try {
            bb.clear();
            int bytesRead = this.channel.read(bb);
            if (-1 == bytesRead) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return TaskStatus.COMPLETE;
            }
            bb.flip();
            return TaskStatus.ONGOING;
        }
        catch (ClosedChannelException cce) {
            return TaskStatus.COMPLETE;
        }
        catch (IOException e) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logger.log(Level.SEVERE, "Error in ChannelReaderService ", e);
            return TaskStatus.COMPLETE;
        }
    }

    ByteBuffer allocate(int capacity, boolean directBuffer) {
        if (directBuffer) {
            return ByteBuffer.allocateDirect(capacity);
        }
        return ByteBuffer.allocate(capacity);
    }
}

