/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.prototype.ver1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.ox.well.t2d.async.prototype.ver1.ExecutionManager;
import uk.ac.ox.well.t2d.async.prototype.ver1.Service;
import uk.ac.ox.well.t2d.async.prototype.ver1.TaskStatus;

public class ChannelReaderService2
implements Service<ReadableByteChannel> {
    Logger logger = Logger.getLogger(this.getClass().getName());
    List<ByteReader> readers = new ArrayList<ByteReader>();
    ReadableByteChannel channel;
    ExecutionManager exe;
    Service<ByteBuffer> sink;

    public ChannelReaderService2(int bufferCount, int bufferCapacity, boolean directBuffer) {
        for (int i = 0; i < bufferCount; ++i) {
            ByteReader bb = this.newByteReader(bufferCapacity, directBuffer);
            this.readers.add(bb);
        }
    }

    public void setSink(Service<ByteBuffer> s) {
        this.sink = s;
    }

    public void setExecutionManager(ExecutionManager em) {
        this.exe = em;
    }

    public void initialize() {
    }

    @Override
    public void commence() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void consume(ReadableByteChannel o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void complete() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TaskStatus read(ByteBuffer bb) {
        try {
            bb.clear();
            int bytesRead = this.channel.read(bb);
            if (-1 == bytesRead) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return TaskStatus.COMPLETE;
            }
            bb.flip();
            return TaskStatus.ONGOING;
        }
        catch (ClosedChannelException cce) {
            return TaskStatus.COMPLETE;
        }
        catch (IOException e) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logger.log(Level.SEVERE, "Error in ChannelReaderService ", e);
            return TaskStatus.COMPLETE;
        }
    }

    ByteReader newByteReader(int capacity, boolean directBuffer) {
        ByteBuffer bb = this.allocate(capacity, directBuffer);
        return new ByteReader(bb);
    }

    ByteBuffer allocate(int capacity, boolean directBuffer) {
        if (directBuffer) {
            return ByteBuffer.allocateDirect(capacity);
        }
        return ByteBuffer.allocate(capacity);
    }

    class ByteShuttle
    implements Runnable {
        TaskStatus status = null;
        ByteReader reader;

        public ByteShuttle(ByteReader br) {
            this.reader = br;
        }

        @Override
        public void run() {
            if (TaskStatus.ONGOING.equals((Object)this.status)) {
                ChannelReaderService2.this.sink.consume(this.reader.bb);
            } else if (TaskStatus.COMPLETE.equals((Object)this.status)) {
                ChannelReaderService2.this.sink.complete();
            } else {
                ChannelReaderService2.this.sink.cancel();
            }
        }
    }

    class ByteReader
    implements Runnable {
        ByteBuffer bb;
        ByteShuttle shuttle;

        public ByteReader(ByteBuffer buf) {
            this.bb = buf;
            this.shuttle = new ByteShuttle(this);
        }

        @Override
        public void run() {
            this.shuttle.status = ChannelReaderService2.this.read(this.bb);
        }
    }
}

