/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.prototype.ver1;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Logger;
import uk.ac.ox.well.t2d.async.prototype.ver1.ExecutionManager;
import uk.ac.ox.well.t2d.async.prototype.ver1.Service;
import uk.ac.ox.well.t2d.async.prototype.ver1.Shuttle;
import uk.ac.ox.well.t2d.async.prototype.ver1.ShuttleRecycler;

public abstract class ShuttleService<O, S>
implements Service<O>,
ShuttleRecycler<S> {
    Logger logger = Logger.getLogger(this.getClass().getName());
    ExecutionManager exe;
    Service<S> sink;
    int shuttleCount = 5;
    Queue<O> inQueue;
    Queue<Shuttle<S>> shuttleQueue;

    public ShuttleService(ExecutionManager em) {
        this.exe = em;
        this.inQueue = new LinkedList<O>();
    }

    public Service<S> getSink() {
        return this.sink;
    }

    public void setSink(Service<S> s) {
        this.sink = s;
    }

    @Override
    public void commence() {
        this.shuttleQueue = new ArrayBlockingQueue<Shuttle<S>>(this.shuttleCount);
        for (int i = 0; i < this.shuttleCount; ++i) {
            Shuttle<S> shuttle = new Shuttle<S>(this.sink, this.exe.getExecutor(this.sink), this);
            shuttle.setObject(this.newPayloadObject());
            this.shuttleQueue.add(shuttle);
        }
    }

    @Override
    public void consume(O o) {
        this.inQueue.add(o);
    }

    @Override
    public void complete() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public abstract void recycle(Shuttle<S> var1);

    public abstract S newPayloadObject();
}

