/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.prototype.ver2;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Command;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Processor;

public abstract class ProcessorBase<PI, PO>
implements Processor<PI>,
Runnable {
    protected Executor executor;
    protected Processor<PO> sinkService;
    protected Integer concurrentExecutionMax = 5;
    protected Queue<Command> inQueue = new ConcurrentLinkedQueue<Command>();
    protected AtomicInteger executionCounter = new AtomicInteger(0);

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Processor<PO> getSinkService() {
        return this.sinkService;
    }

    public void setSinkService(Processor<PO> sinkService) {
        this.sinkService = sinkService;
    }

    @Override
    public void consume(Contract c, Bucket<PI> b, boolean endOfInput) {
        if (!endOfInput) {
            this.inQueue.add(new Command<PI>(Command.Type.CONSUME, c, b));
        } else {
            this.inQueue.add(new Command(Command.Type.COMPLETE, c, null));
        }
        this.promptService();
    }

    public void cancel(Contract c) {
        this.promptService();
    }

    protected void promptService() {
        if (this.obtainPermitToExecute()) {
            this.executor.execute(this);
        }
    }

    protected boolean obtainPermitToExecute() {
        int count;
        do {
            count = this.executionCounter.get();
            if (this.concurrentExecutionMax > count) continue;
            return false;
        } while (!this.executionCounter.compareAndSet(count, count++));
        return true;
    }

    @Override
    public void run() {
        Command qc = this.inQueue.poll();
        if (null == qc) {
            return;
        }
        this.task(qc);
        this.executionCounter.decrementAndGet();
        if (null != this.inQueue.peek()) {
            this.promptService();
        }
    }

    protected void task(Command qc) {
        if (Command.Type.CONSUME.equals((Object)qc.getType())) {
            this.consumeTask(qc.getContract(), qc.getBucket(), false);
        } else if (Command.Type.COMPLETE.equals((Object)qc.getType())) {
            this.consumeTask(qc.getContract(), qc.getBucket(), true);
        } else if (Command.Type.CANCEL.equals((Object)qc.getType())) {
            this.cancelTask(qc.getContract());
        } else {
            throw new RuntimeException("Unknown Command: " + qc.toString());
        }
    }

    protected abstract void consumeTask(Contract var1, Bucket<PI> var2, boolean var3);

    protected abstract void cancelTask(Contract var1);
}

