/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.prototype.ver2;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Command;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Processor;

public class Regulator<P>
implements Processor<P> {
    protected Set<Contract> currentlyExecuting = new HashSet<Contract>();
    protected LinkedHashMap<Contract, Queue<Command>> qMap = new LinkedHashMap();
    protected Integer concurrentExecutionMax = 1;
    protected Executor executor;
    protected Processor<P> processor;

    public void setConcurrentExecutionMax(Integer i) {
        this.concurrentExecutionMax = i;
    }

    public void setExecutor(Executor e) {
        this.executor = e;
    }

    public void setProcessor(Processor<P> p) {
        this.processor = p;
    }

    @Override
    public void commence() {
        this.processor.commence();
    }

    @Override
    public void close() {
    }

    @Override
    public void consume(Contract c, Bucket<P> b, boolean isEndOfInput) {
        if (!isEndOfInput) {
            this.queueCommand(new Command<P>(Command.Type.CONSUME, c, b));
        } else {
            this.queueCommand(new Command<P>(Command.Type.COMPLETE, c, b));
        }
        this.prompt();
    }

    public void cancel(Contract c) {
        this.queueCommand(new Command(Command.Type.CANCEL, c, null));
        this.prompt();
    }

    public synchronized void queueCommand(Command c) {
        Queue<Command> q = this.qMap.get(c.getContract());
        if (null == q) {
            q = this.newQueue();
            this.qMap.put(c.getContract(), q);
        }
        q.add(c);
    }

    public Queue<Command> newQueue() {
        return new ConcurrentLinkedQueue<Command>();
    }

    public void prompt() {
        Command command;
        while (null != (command = this.pollCommand())) {
            ExecutorRunnable r = new ExecutorRunnable(command);
            this.executor.execute(r);
        }
    }

    protected synchronized Command pollCommand() {
        if (this.concurrentExecutionMax <= this.currentlyExecuting.size()) {
            return null;
        }
        for (Map.Entry<Contract, Queue<Command>> e : this.qMap.entrySet()) {
            if (this.currentlyExecuting.contains(e.getKey()) || e.getValue().isEmpty()) continue;
            this.currentlyExecuting.add(e.getKey());
            return e.getValue().remove();
        }
        return null;
    }

    protected void switchCommand(Command qc) {
        if (Command.Type.CONSUME.equals((Object)qc.getType())) {
            this.processor.consume(qc.getContract(), qc.getBucket(), false);
        } else if (Command.Type.COMPLETE.equals((Object)qc.getType())) {
            this.processor.consume(qc.getContract(), qc.getBucket(), true);
        } else {
            throw new RuntimeException("Unknown Command: " + qc.toString());
        }
    }

    public synchronized void completeCommand(Command qc) {
        this.currentlyExecuting.remove(qc.getContract());
        if (Command.Type.COMPLETE.equals((Object)qc.getType())) {
            this.qMap.remove(qc.getContract());
        }
        this.prompt();
    }

    public class ExecutorRunnable
    implements Runnable {
        Command command;

        public ExecutorRunnable(Command qc) {
            this.command = qc;
        }

        @Override
        public void run() {
            Regulator.this.switchCommand(this.command);
            Regulator.this.completeCommand(this.command);
        }
    }
}

