/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.prototype.ver3;

import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Command;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.processors.CommandQueue;
import uk.ac.ox.well.t2d.async.processors.ContextManager;
import uk.ac.ox.well.t2d.async.processors.SerialCommandQueue;

public abstract class AbstractProcessor<CX, PI>
implements Processor<PI> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ExecutorService executor;
    protected Processor processor;
    protected ContextManager<CX> contextManager;
    protected CommandQueue<PI> commandQueue = new SerialCommandQueue();

    public AbstractProcessor() {
        this.contextManager = new AbstractProcessorContextManager();
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    public void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    @Override
    public void commence() {
    }

    @Override
    public void close() {
    }

    @Override
    public void consume(Contract c, Bucket<PI> b, boolean endOfInput) {
        if (!endOfInput) {
            this.commandAdd(new Command<PI>(Command.Type.CONSUME, c, b));
        } else {
            this.commandAdd(new Command<PI>(Command.Type.COMPLETE, c, b));
        }
        this.prompt();
    }

    public void prompt() {
        AbstractProcessorRunnable runnable;
        while (null != (runnable = this.poll())) {
            this.execute(runnable);
        }
    }

    protected void execute(Runnable r) {
        this.executor.execute(r);
    }

    protected synchronized AbstractProcessorRunnable poll() {
        Command<PI> cmd = this.commandPoll();
        if (null == cmd) {
            return null;
        }
        CX cxt = this.getContext(cmd.getContract());
        AbstractProcessorRunnable runnable = new AbstractProcessorRunnable(cxt, cmd);
        return runnable;
    }

    public synchronized Command<PI> commandPoll() {
        return this.commandQueue.poll();
    }

    public synchronized void commandAdd(Command<PI> cmd) {
        this.commandQueue.queue(cmd);
    }

    public synchronized void commandAddFirst(Command<PI> cmd) {
        this.commandQueue.requeue(cmd);
    }

    public synchronized void commandComplete(Command<PI> cmd) {
        this.commandQueue.complete(cmd);
    }

    protected abstract CX newContext(Contract var1);

    protected CX getContext(Contract c) {
        if (null != this.contextManager) {
            return this.contextManager.getContext(c);
        }
        throw new NullPointerException("ContextManager has not been set");
    }

    protected void removeContext(Contract c) {
        if (null == this.contextManager) {
            throw new NullPointerException("ContextManager has not been set");
        }
        this.contextManager.removeContext(c);
    }

    protected abstract void process(CX var1, Bucket<PI> var2, boolean var3) throws Exception;

    protected void processingCompleted(Command<PI> cmd) {
        if (cmd.isEndOfInput()) {
            this.removeContext(cmd.getContract());
        }
        this.prompt();
    }

    public class AbstractProcessorContextManager
    extends ContextManager<CX> {
        @Override
        protected CX newContext(Contract c) {
            return AbstractProcessor.this.newContext(c);
        }
    }

    public class AbstractProcessorRunnable
    implements Runnable {
        private Command<PI> cmd;
        private CX cxt;

        public AbstractProcessorRunnable(CX processingContext, Command<PI> command) {
            this.cxt = processingContext;
            this.cmd = command;
        }

        @Override
        public void run() {
            try {
                AbstractProcessor.this.process(this.cxt, this.cmd.getBucket(), this.cmd.isEndOfInput());
                AbstractProcessor.this.processingCompleted(this.cmd);
            }
            catch (Exception e) {
                this.cmd.getContract().fail(e);
            }
        }
    }
}

