/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.sort;

public class BinaryUtilities {
    public static long charArrayToInt(char[] ca) {
        long rv = 0L;
        rv = BinaryUtilities.charToInt(0, ca[0], rv);
        rv = BinaryUtilities.charToInt(1, ca[1], rv);
        return rv;
    }

    public static long charToInt(int offset, long source, long dest) {
        return BinaryUtilities.replaceBitSection(16, offset, source, dest);
    }

    public static char[] intToCharArray(int i) {
        char[] ca = new char[]{(char)BinaryUtilities.intToChar(0, i), (char)BinaryUtilities.intToChar(1, i)};
        return ca;
    }

    public static long intToChar(int offset, long source) {
        return BinaryUtilities.captureBitSection(16, offset, source);
    }

    public static long byteArrayToInt(byte[] ba) {
        long rv = 0L;
        rv = BinaryUtilities.byteToInt(0, ba[0], rv);
        rv = BinaryUtilities.byteToInt(1, ba[1], rv);
        rv = BinaryUtilities.byteToInt(2, ba[2], rv);
        rv = BinaryUtilities.byteToInt(3, ba[3], rv);
        return rv;
    }

    public static long byteToInt(int offset, long source, long dest) {
        return BinaryUtilities.replaceBitSection(8, offset, source, dest);
    }

    public static byte[] intToByteArray(int i) {
        byte[] ba = new byte[]{(byte)BinaryUtilities.intToByte(0, i), (byte)BinaryUtilities.intToByte(1, i), (byte)BinaryUtilities.intToByte(2, i), (byte)BinaryUtilities.intToByte(3, i)};
        return ba;
    }

    public static long intToByte(int offset, long source) {
        return BinaryUtilities.captureBitSection(8, offset, source);
    }

    public static long replaceBitSection(int width, int offset, long source, long dest) {
        long rv = dest;
        int ioff = offset * width;
        for (int i = 0; i < width; ++i) {
            boolean b = BinaryUtilities.isBitSet(i, source);
            rv = BinaryUtilities.setBit(b, i + ioff, rv);
        }
        return rv;
    }

    public static long captureBitSection(int width, int offset, long source) {
        long rv = 0L;
        int ioff = offset * width;
        int iend = ioff + width;
        for (int i = ioff; i < iend; ++i) {
            boolean b = BinaryUtilities.isBitSet(i, source);
            rv = BinaryUtilities.setBit(b, i - ioff, rv);
        }
        return rv;
    }

    public static boolean isBitSet(int offset, long b) {
        long bm = BinaryUtilities.getBitmask(offset);
        return (b & bm) == bm;
    }

    public static long setBit(boolean isSet, int offset, long b) {
        long mask = BinaryUtilities.getBitmask(offset);
        if (!isSet) {
            return (mask ^= 0xFFFFFFFFFFFFFFFFL) & b;
        }
        return mask | b;
    }

    public static long getBitmask(int offset) {
        long bm = 1L;
        return bm << offset;
    }

    public static String toBitString(long c) {
        return BinaryUtilities.toBitString(32, c);
    }

    public static String toBitString8(long c) {
        return BinaryUtilities.toBitString(8, c);
    }

    public static String toBitString16(long c) {
        return BinaryUtilities.toBitString(8, c);
    }

    public static String toBitString(int width, long c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            boolean b = BinaryUtilities.isBitSet(i, c);
            if (b) {
                sb.append("1");
                continue;
            }
            sb.append("0");
        }
        return sb.reverse().toString();
    }
}

