/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.sort;

import java.util.List;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.BasicContract;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;
import uk.ac.ox.well.t2d.async.processors.BucketBase;

public class InMemoryListMergeLooper
extends AbstractConveyor<Context, List, List> {
    protected Processor merger;

    @Override
    protected Context newContext() {
        return new Context();
    }

    public void setMerger(Processor p) {
        this.merger = p;
    }

    public class LooperContract
    extends BasicContract {
        protected int looperCount;
        protected int elementCount;
        protected LooperContract previousContract;

        public LooperContract(Contract parent) {
            super(parent);
            this.looperCount = 1;
            this.elementCount = 0;
            this.previousContract = null;
        }

        public LooperContract(LooperContract prev) {
            super(prev.getSuperContract());
            this.previousContract = prev;
            this.looperCount = prev.looperCount + 1;
        }

        public LooperContract getPreviousContract() {
            return this.previousContract;
        }

        @Override
        public String toString() {
            return "LooperContract. No:" + this.looperCount + ", ElementCount: " + this.elementCount;
        }
    }

    public static class PairMaker {
        List[] array = new List[2];
        int offset;

        public List[] add(List o) {
            this.array[this.offset] = o;
            ++this.offset;
            if (this.offset >= this.array.length) {
                List[] rv = this.array;
                this.array = new List[2];
                this.offset = 0;
                return rv;
            }
            return null;
        }
    }

    public class Context
    extends ProcessingContext<List, List> {
        PairMaker pairr;
        LooperContract nextContract;

        @Override
        public void initialize() {
            this.pairr = new PairMaker();
            this.nextContract = null;
        }

        @Override
        public ProcessingResult process(List pi, Bucket<List> po, boolean endOfContract) throws Exception {
            List[] array = this.pairr.add(pi);
            if (null != array) {
                if (null == this.nextContract) {
                    this.nextContract = this.newLooperContract();
                }
                BucketBase<List[]> bb = new BucketBase<List[]>();
                bb.setPayload(array);
                this.nextContract.elementCount += array[0].size() + array[1].size();
                InMemoryListMergeLooper.this.merger.consume(this.nextContract, bb, endOfContract);
                if (endOfContract) {
                    po.recycle();
                }
                return ProcessingResult.INPUT_COMPLETE;
            }
            if (endOfContract && null == this.nextContract) {
                po.setPayload(pi);
                return ProcessingResult.BOTH_COMPLETE;
            }
            if (endOfContract && null != this.nextContract) {
                BucketBase<List[]> bb = new BucketBase<List[]>();
                bb.setPayload(this.pairr.array);
                this.nextContract.elementCount += pi.size();
                InMemoryListMergeLooper.this.merger.consume(this.nextContract, bb, endOfContract);
                po.recycle();
                return ProcessingResult.INPUT_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }

        public LooperContract newLooperContract() {
            LooperContract newContract;
            Contract currentContract = this.getContract();
            if (currentContract instanceof LooperContract) {
                LooperContract previousContract = (LooperContract)currentContract;
                newContract = new LooperContract(previousContract);
            } else {
                newContract = new LooperContract(currentContract);
            }
            newContract.getSuperContract().addSubContract(newContract.getSuperContract());
            return newContract;
        }
    }
}

