/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.sort;

import java.util.List;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;
import uk.ac.ox.well.t2d.async.sort.ListMerger;
import uk.ac.ox.well.t2d.async.sort.SmartArrayComparator;
import uk.ac.ox.well.t2d.async.sort.SmartCharArrayComparator;

public class InMemoryListMerger
extends AbstractConveyor<Context, List[], List> {
    protected SmartArrayComparator comparator = new SmartCharArrayComparator();

    public InMemoryListMerger setComparator(SmartArrayComparator cptr) {
        this.comparator = cptr;
        return this;
    }

    @Override
    protected Context newContext() {
        return new Context();
    }

    public class Context
    extends ProcessingContext<List[], List> {
        @Override
        public ProcessingResult process(List[] pi, Bucket<List> po, boolean endOfContract) throws Exception {
            if (null == pi) {
                throw new NullPointerException("List Array is Null. It should not be.");
            }
            if (2 != pi.length) {
                throw new RuntimeException("Expecting an array of size 2. Found length: " + pi.length);
            }
            if (null == pi[0] && null == pi[1]) {
                throw new RuntimeException("Expecting at least 1 non-null value in array. Found none.");
            }
            if (null == pi[1]) {
                po.setPayload(pi[0]);
            } else if (null == pi[0]) {
                po.setPayload(pi[1]);
            } else {
                ListMerger lm = new ListMerger(InMemoryListMerger.this.comparator, pi[0], pi[1]);
                lm.run();
                List lst = lm.getMergedList();
                po.setPayload(lst);
            }
            return ProcessingResult.BOTH_COMPLETE;
        }
    }
}

