/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.sort;

import java.util.List;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.ped.WhiteSpaceParsingLogic;
import uk.ac.ox.well.t2d.async.sort.PhantomReferenceLogger;
import uk.ac.ox.well.t2d.async.sort.SmartArrayComparator;
import uk.ac.ox.well.t2d.async.sort.SmartCharArrayComparator;

public class IndexEntryLoader
extends TableParser<List> {
    protected int maxLength = 4000;
    protected int columnNumber;
    protected SmartArrayComparator comparator;

    public IndexEntryLoader() {
        this.setPayloadManager(new CollectionFactory.ListFactory().setReuse(false));
        this.columnNumber = 1;
        this.comparator = new SmartCharArrayComparator();
    }

    public IndexEntryLoader setMaxLength(int ml) {
        this.maxLength = ml;
        return this;
    }

    public IndexEntryLoader setColumnNumber(int cn) {
        this.columnNumber = cn;
        return this;
    }

    public IndexEntryLoader setComparator(SmartArrayComparator c) {
        this.comparator = c;
        return this;
    }

    @Override
    protected TableParsingLogic<List> newLogic() {
        return new WhiteSpaceParsingLogic();
    }

    @Override
    protected TableCellHandler<List> newHandler() {
        return new Handler();
    }

    public class TestIndexSize {
        int l1 = 999999999;
        int l2 = 999999999;
        int l3 = 999999999;
    }

    public static class GcMonitoringListFactory
    extends CollectionFactory.ListFactory {
        @Override
        public List newPayload() {
            List l = super.newPayload();
            PhantomReferenceLogger.INSTANCE.addReference("IndexEntryLoader.List", l);
            return l;
        }
    }

    public class Handler
    extends TableCellHandlerBase<List> {
        long count = 0L;

        @Override
        public boolean cell(TableCellMetadata meta, CharArraySequence cellData, List po) throws Exception {
            if ((long)IndexEntryLoader.this.columnNumber == meta.getColumnNumber()) {
                Object sa = IndexEntryLoader.this.comparator.newSmartArray(cellData, (int)meta.getLineNumber());
                po.add(sa);
                ++this.count;
                return IndexEntryLoader.this.maxLength <= po.size();
            }
            return false;
        }

        public Comparable toComparable(CharArraySequence cellData) {
            return cellData.toString();
        }

        @Override
        public void clear() {
            this.count = 0L;
        }
    }
}

