/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.sort;

import java.util.Collections;
import java.util.List;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.processors.BucketBase;

public class ListChunker
extends BasicProcessor {
    int maxChunkSize = 10000;

    public ListChunker setMaxChunkSize(int cs) {
        this.maxChunkSize = cs;
        return this;
    }

    @Override
    public void consume(Contract c, Bucket bin, boolean endOfInput) {
        List l = (List)bin.getPayload();
        if (l.isEmpty()) {
            this.getProcessor().consume(c, this.newEmptyBucket(), endOfInput);
        } else {
            for (int start = 0; start < l.size(); start += this.maxChunkSize) {
                int endEx = start + this.maxChunkSize;
                boolean finalChunk = false;
                if (endEx >= l.size()) {
                    endEx = l.size();
                    finalChunk = true;
                }
                Bucket b = this.newBucket(l, start, endEx);
                this.getProcessor().consume(c, b, finalChunk && endOfInput);
            }
        }
        bin.recycle();
    }

    public Bucket newBucket(List parent, int start, int end) {
        List child = this.subList(parent, start, end);
        BucketBase<List> b = new BucketBase<List>();
        b.setPayload(child);
        return b;
    }

    public Bucket newEmptyBucket() {
        List child = Collections.EMPTY_LIST;
        BucketBase<List> b = new BucketBase<List>();
        b.setPayload(child);
        return b;
    }

    public List subList(List parent, int start, int end) {
        return parent.subList(start, end);
    }
}

