/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.sort;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class PhantomReferenceLogger {
    public static final PhantomReferenceLogger INSTANCE = new PhantomReferenceLogger();
    public ReferenceQueue deadQueue = new ReferenceQueue();
    public HashMap referenceMap = new HashMap();
    public HashMap counterMap = new HashMap();
    public QueuePoller poller = null;

    public synchronized PhantomReferenceLogger addReference(String label, Object o) {
        return this.addReference(label, o, null);
    }

    public synchronized PhantomReferenceLogger addReference(String label, Object o, String info) {
        if (null == this.poller) {
            this.poller = new QueuePoller();
            new Thread(this.poller).start();
        }
        String tag = this.createTag(label);
        if (null != info) {
            tag = tag + ": " + info;
        }
        PhantomReference<Object> pr = new PhantomReference<Object>(o, this.deadQueue);
        this.referenceMap.put(pr, tag);
        return this;
    }

    public String createTag(String label) {
        AtomicInteger ai = (AtomicInteger)this.counterMap.get(label);
        if (null == ai) {
            ai = new AtomicInteger(0);
            this.counterMap.put(label, ai);
        }
        int i = ai.incrementAndGet();
        String tag = label + "~" + i;
        return tag;
    }

    public class GcCaller
    implements Runnable {
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                System.gc();
                System.out.println("GC Called");
            }
        }
    }

    public class QueuePoller
    implements Runnable {
        int c = 0;

        @Override
        public void run() {
            try {
                while (true) {
                    PhantomReference pr = (PhantomReference)PhantomReferenceLogger.this.deadQueue.remove();
                    ++this.c;
                    String tag = (String)PhantomReferenceLogger.this.referenceMap.get(pr);
                    System.out.println("Removed Reference#" + this.c + ", Tag=" + tag);
                    PhantomReferenceLogger.this.referenceMap.remove(pr);
                }
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

