/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.sort;

import uk.ac.ox.well.t2d.async.sort.BinaryUtilities;
import uk.ac.ox.well.t2d.async.sort.SmartArrayComparator;

public class SmartByteArrayComparator
implements SmartArrayComparator<byte[]> {
    @Override
    public final int compare(byte[] a1, byte[] a2) {
        int i2;
        if (4 > a1.length) {
            throw new RuntimeException("SmartByteArrays must have at least length 4. Array 1 has length " + a1.length);
        }
        if (4 > a2.length) {
            throw new RuntimeException("SmartByteArrays must have at least length 4. Array 2 has length " + a2.length);
        }
        int maxLen = a1.length;
        if (maxLen < a2.length) {
            maxLen = a2.length;
        }
        for (int i = 4; i < maxLen; ++i) {
            if (a1.length <= i) {
                return -1;
            }
            if (a2.length <= i) {
                return 1;
            }
            if (a1[i] < a2[i]) {
                return -1;
            }
            if (a2[i] >= a1[i]) continue;
            return 1;
        }
        int i1 = this.getSmartArrayIndex(a1);
        if (i1 < (i2 = this.getSmartArrayIndex(a2))) {
            return -1;
        }
        if (i2 < i1) {
            return 1;
        }
        return 0;
    }

    @Override
    public final byte[] newSmartArray(CharSequence cs, int index) {
        byte[] ba = new byte[cs.length() + 4];
        for (int i = 0; i < cs.length(); ++i) {
            ba[4 + i] = (byte)cs.charAt(i);
        }
        ba[0] = (byte)BinaryUtilities.intToByte(0, index);
        ba[1] = (byte)BinaryUtilities.intToByte(1, index);
        ba[2] = (byte)BinaryUtilities.intToByte(2, index);
        ba[3] = (byte)BinaryUtilities.intToByte(3, index);
        return ba;
    }

    @Override
    public final int getSmartArrayIndex(byte[] ba) {
        return (int)BinaryUtilities.byteArrayToInt(ba);
    }

    @Override
    public String getSmartArrayData(byte[] t) {
        char[] ca = new char[t.length - 4];
        for (int i = 0; i < ca.length; ++i) {
            ca[i] = (char)t[i + 4];
        }
        return new String(ca);
    }
}

