/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.svg;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class SvgTranscoder
extends AbstractConveyor {
    public static final String FORMAT_KEY = "SvgTranscoder.Format";

    protected ProcessingContext newContext() {
        return new Context();
    }

    public ImageTranscoder newImageTranscoder(Format f) {
        switch (f) {
            case TIFF: {
                return this.newTiffTranscoder();
            }
            case JPEG: {
                return this.newJpegTranscoder();
            }
        }
        return this.newPngTranscoder();
    }

    public ImageTranscoder newJpegTranscoder() {
        JPEGTranscoder trans = new JPEGTranscoder();
        trans.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
        return trans;
    }

    public ImageTranscoder newPngTranscoder() {
        PNGTranscoder trans = new PNGTranscoder();
        return trans;
    }

    public ImageTranscoder newTiffTranscoder() {
        TIFFTranscoder trans = new TIFFTranscoder();
        return trans;
    }

    public Format getFormat(Contract c) {
        String formatStr = (String)c.get(FORMAT_KEY);
        if (formatStr.equalsIgnoreCase(Format.TIFF.toString())) {
            return Format.TIFF;
        }
        if (formatStr.equalsIgnoreCase(Format.JPEG.toString())) {
            return Format.JPEG;
        }
        return Format.PNG;
    }

    public class Context
    extends ProcessingContext<Path, ByteBuffer> {
        Format currentFormat = null;
        ImageTranscoder trans = new PNGTranscoder();

        @Override
        public void initialize() {
            Contract c = this.getContract();
            String formatStr = (String)c.get(SvgTranscoder.FORMAT_KEY);
            if (null != formatStr) {
                // empty if block
            }
        }

        @Override
        public ProcessingResult process(Path pi, Bucket<ByteBuffer> po, boolean endOfContract) {
            String urii = pi.toFile().toURI().toString();
            TranscoderInput input = new TranscoderInput(urii);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                TranscoderOutput output = new TranscoderOutput((OutputStream)baos);
                this.trans.transcode(input, output);
            }
            catch (TranscoderException ex) {
                Logger.getLogger(SvgTranscoder.class.getName()).log(Level.SEVERE, null, ex);
            }
            ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
            po.setPayload(buf);
            return ProcessingResult.BOTH_COMPLETE;
        }
    }

    public static enum Format {
        TIFF,
        JPEG,
        PNG;

    }
}

