/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.table.QuickHeaderTableHandler;

public abstract class HeaderTableCellHandlerBase<PO>
extends TableCellHandlerBase<PO> {
    public static final Logger logger = LoggerFactory.getLogger(QuickHeaderTableHandler.class);
    boolean isLabelLine = true;
    List<String> labelList = new ArrayList<String>();
    Map<String, Integer> duplicateLabels = new LinkedHashMap<String, Integer>();

    @Override
    public void clear() {
        this.isLabelLine = true;
        this.labelList.clear();
        this.duplicateLabels.clear();
    }

    @Override
    public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Bucket<PO> bo) throws Exception {
        if (1L == meta.getColumnNumber() && meta.isEndOfLine() && cellData.length() == 0) {
            return false;
        }
        if (this.isLabelLine) {
            this.headerCell(meta, cellData, bo);
            return false;
        }
        if (meta.getColumnNumber() > (long)this.labelList.size()) {
            throw new RuntimeException("Too many cells on line " + meta.getLineNumber() + ". Expecting " + this.labelList.size() + " cells, but found " + meta.getColumnNumber() + ". Could there be too many cell delimiters on this line?");
        }
        return this.bodyCell(meta, cellData, bo);
    }

    public void headerCell(TableCellMetadata meta, CharArraySequence cellData, Bucket<PO> bo) throws Exception {
        this.labelList.add(cellData.toString());
        if (meta.isEndOfLine()) {
            this.endOfHeaderLine();
        }
    }

    public void endOfHeaderLine() throws Exception {
        this.detectDuplicateLabels();
        this.isLabelLine = false;
    }

    public abstract boolean bodyCell(TableCellMetadata var1, CharArraySequence var2, Bucket<PO> var3) throws Exception;

    public Map<String, Integer> getDuplicateLabels() {
        return Collections.unmodifiableMap(this.duplicateLabels);
    }

    public void detectDuplicateLabels() {
        HashSet<String> labelSet = new HashSet<String>();
        for (int i = 0; i < this.labelList.size(); ++i) {
            String str = this.labelList.get(i);
            if (labelSet.contains(str)) {
                this.duplicateLabels.put(str, i);
                Formatter f = new Formatter();
                f.format("Found duplicate header label at line %d: \"%s\". Data in this column will be ignored during the parse.", i, str);
                logger.warn(f.toString());
                continue;
            }
            labelSet.add(str);
        }
    }
}

