/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.table.MapHandler;

public class HeaderTableHandler<PO>
implements TableCellHandler<PO> {
    public static final Logger logger = LoggerFactory.getLogger(HeaderTableHandler.class);
    TableParser.TableParsingContext<PO> context;
    boolean isLabelLine = true;
    List<String> labelList = new ArrayList<String>();
    Map<String, Integer> duplicateLabels = new LinkedHashMap<String, Integer>();
    Map<String, String> lineData;
    MapHandler<PO> handler;

    public HeaderTableHandler(MapHandler<PO> mh) {
        this.handler = mh;
    }

    @Override
    public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Bucket<PO> bo) throws Exception {
        if (1L == meta.getColumnNumber() && meta.isEndOfLine() && cellData.length() == 0) {
            return false;
        }
        if (1L == meta.getColumnNumber()) {
            this.startLine();
        }
        this.captureCell(meta, cellData);
        if (meta.isEndOfLine()) {
            return this.endLine(meta, cellData, bo);
        }
        return false;
    }

    @Override
    public void clear() {
        this.isLabelLine = true;
        this.labelList.clear();
        this.duplicateLabels.clear();
        this.handler.clear();
        this.lineData = null;
    }

    @Override
    public TableParser.TableParsingContext<PO> getTableParsingContext() {
        return this.context;
    }

    @Override
    public void setTableParsingContext(TableParser.TableParsingContext<PO> tpc) {
        this.context = tpc;
    }

    @Override
    public boolean flush(Bucket<PO> bo) {
        return this.handler.flush(bo);
    }

    @Override
    public boolean startTable(Bucket<PO> bo) throws Exception {
        return this.handler.startTable(bo);
    }

    @Override
    public boolean endTable(Bucket<PO> bo) throws Exception {
        return this.handler.endTable(bo);
    }

    public Map<String, Integer> getDuplicateLabels() {
        return Collections.unmodifiableMap(this.duplicateLabels);
    }

    public void startLine() {
        if (!this.isLabelLine) {
            this.lineData = new LinkedHashMap<String, String>();
        }
    }

    public void captureCell(TableCellMetadata meta, CharArraySequence cellData) {
        String str = cellData.toString();
        if (this.isLabelLine) {
            this.labelList.add(str);
        } else {
            if (meta.getColumnNumber() > (long)this.labelList.size()) {
                throw new RuntimeException("Too many cells on line " + meta.getLineNumber() + ". Expecting " + this.labelList.size() + " cells, but found " + meta.getColumnNumber() + ". Could there be too many cell delimiters on this line?");
            }
            String label = this.labelList.get((int)meta.getColumnNumber() - 1);
            if (!this.lineData.containsKey(label)) {
                this.lineData.put(label, str);
            }
        }
    }

    public boolean endLine(TableCellMetadata meta, CharArraySequence cellData, Bucket<PO> bo) throws Exception {
        if (this.isLabelLine) {
            this.detectDuplicateLabels();
            this.isLabelLine = false;
            return false;
        }
        return this.handler.handleRecord(meta.getLineNumber(), this.lineData, bo);
    }

    public void detectDuplicateLabels() {
        HashSet<String> labelSet = new HashSet<String>();
        for (int i = 0; i < this.labelList.size(); ++i) {
            String str = this.labelList.get(i);
            if (labelSet.contains(str)) {
                this.duplicateLabels.put(str, i);
                Formatter f = new Formatter();
                f.format("Found duplicate header label at line %d: \"%s\". Data in this column will be ignored during the parse", i, str);
                logger.warn(f.toString());
                continue;
            }
            labelSet.add(str);
        }
    }
}

