/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.table.HeaderTableCellHandlerBase;
import uk.ac.ox.well.t2d.async.table.IndexMapHandler;

public class IndexMapTableHandler<PO>
extends HeaderTableCellHandlerBase<PO> {
    protected IndexMapHandler<PO> handler;
    protected String[] requiredColumnHeaders;
    protected int[] columnIndexMap;

    public IndexMapTableHandler(IndexMapHandler<PO> mh) {
        this.handler = mh;
        this.requiredColumnHeaders = this.handler.getRequiredColumnHeaders();
    }

    @Override
    public void clear() {
        super.clear();
        this.handler.clear();
        this.columnIndexMap = null;
    }

    @Override
    public boolean startTable(Bucket<PO> bo) throws Exception {
        return this.handler.startTable(bo);
    }

    @Override
    public boolean endTable(Bucket<PO> bo) throws Exception {
        return this.handler.endTable(bo);
    }

    @Override
    public boolean bodyCell(TableCellMetadata meta, CharArraySequence cellData, Bucket<PO> bo) throws Exception {
        if (1L == meta.getColumnNumber()) {
            this.handler.startRecord(meta, bo);
        }
        int colNo = (int)meta.getColumnNumber();
        if (-1 != this.columnIndexMap[--colNo]) {
            this.handler.cellData(meta, this.columnIndexMap[colNo], cellData, bo);
        }
        if (meta.isEndOfLine()) {
            return this.handler.endRecord(meta, bo);
        }
        return false;
    }

    @Override
    public void endOfHeaderLine() throws Exception {
        super.endOfHeaderLine();
        this.columnIndexMap = this.buildColumnIndexMap();
    }

    public int[] buildColumnIndexMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.requiredColumnHeaders.length; ++i) {
            map.put(this.requiredColumnHeaders[i], i);
        }
        int[] index = new int[this.labelList.size()];
        for (int i = 0; i < index.length; ++i) {
            index[i] = -1;
        }
        HashSet<String> lblSet = new HashSet<String>();
        for (int i = 0; i < this.labelList.size(); ++i) {
            String lbl = (String)this.labelList.get(i);
            Integer igr = (Integer)map.get(lbl);
            if (null == igr || lblSet.contains(lbl)) continue;
            index[i] = igr;
            lblSet.add(lbl);
        }
        HashSet<String> notFound = new HashSet<String>();
        notFound.addAll(Arrays.asList(this.requiredColumnHeaders));
        notFound.removeAll(this.labelList);
        if (!notFound.isEmpty()) {
            logger.info("Did not find a header for columns: " + notFound);
        }
        return index;
    }
}

