/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.table;

import java.util.HashMap;
import java.util.HashSet;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.table.ArrayHandler;
import uk.ac.ox.well.t2d.async.table.HeaderTableCellHandlerBase;

public class QuickHeaderTableHandler<PO>
extends HeaderTableCellHandlerBase<PO> {
    protected ArrayHandler<PO> handler;
    protected String[] requiredColumnHeaders;
    protected int[] columnIndexMap;
    protected String[] lineData;

    public QuickHeaderTableHandler(ArrayHandler<PO> mh) {
        this.handler = mh;
        this.requiredColumnHeaders = this.handler.getRequiredColumnHeaders();
    }

    @Override
    public void clear() {
        super.clear();
        this.handler.clear();
        this.columnIndexMap = null;
        this.lineData = null;
    }

    @Override
    public boolean startTable(Bucket<PO> bo) throws Exception {
        return this.handler.startTable(bo);
    }

    @Override
    public boolean endTable(Bucket<PO> bo) throws Exception {
        return this.handler.endTable(bo);
    }

    @Override
    public boolean bodyCell(TableCellMetadata meta, CharArraySequence cellData, Bucket<PO> bo) throws Exception {
        int colNo;
        if (1L == meta.getColumnNumber()) {
            this.lineData = new String[this.requiredColumnHeaders.length];
        }
        if (-1 != this.columnIndexMap[colNo = (int)meta.getColumnNumber()]) {
            this.lineData[colNo] = cellData.toString();
        }
        if (meta.isEndOfLine()) {
            return this.handler.handleRecord(meta.getLineNumber(), this.lineData, bo);
        }
        return false;
    }

    public void captureCell(TableCellMetadata meta, CharArraySequence cellData) {
        if (this.isLabelLine) {
            this.labelList.add(cellData.toString());
        } else if (meta.getColumnNumber() > (long)this.labelList.size()) {
            throw new RuntimeException("Too many cells on line " + meta.getLineNumber() + ". Expecting " + this.labelList.size() + " cells, but found " + meta.getColumnNumber() + ". Could there be too many cell delimiters on this line?");
        }
    }

    public boolean endLine(TableCellMetadata meta, CharArraySequence cellData, Bucket<PO> bo) throws Exception {
        if (this.isLabelLine) {
            this.detectDuplicateLabels();
            this.isLabelLine = false;
        } else {
            this.handler.handleRecord(meta.getLineNumber(), this.lineData, bo);
        }
        return false;
    }

    @Override
    public void endOfHeaderLine() throws Exception {
        super.endOfHeaderLine();
        this.columnIndexMap = this.buildColumnIndexMap();
    }

    public int[] buildColumnIndexMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.requiredColumnHeaders.length; ++i) {
            map.put(this.requiredColumnHeaders[i], i);
        }
        int[] index = new int[this.requiredColumnHeaders.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = -1;
        }
        HashSet<String> lblSet = new HashSet<String>();
        for (int i = 0; i < this.labelList.size(); ++i) {
            String lbl = (String)this.labelList.get(i);
            Integer igr = (Integer)map.get(lbl);
            if (null == igr || lblSet.contains(lbl)) continue;
            index[i] = igr;
            lblSet.add(lbl);
        }
        return index;
    }
}

