/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.taqman;

import java.util.Map;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.MapEntry;
import uk.ac.ox.well.t2d.async.table.HeaderTableEntry;

public class AssayMetadata
implements HeaderTableEntry {
    private String assayId;
    private String snpId;
    private String chromosome;
    private String position;
    private String famAllele;
    private String vicAllele;

    public AssayMetadata() {
    }

    public AssayMetadata(String assayId, String snpId, String famAllele, String vicAllele) {
        this.assayId = assayId;
        this.snpId = snpId;
        this.famAllele = famAllele;
        this.vicAllele = vicAllele;
    }

    public AssayMetadata(String assayId, String snpId, String chromosome, String position, String famAllele, String vicAllele) {
        this.assayId = assayId;
        this.snpId = snpId;
        this.chromosome = chromosome;
        this.position = position;
        this.famAllele = famAllele;
        this.vicAllele = vicAllele;
    }

    @Override
    public void set(long lineNumber, Map<String, String> data) throws Exception {
        this.assayId = data.get("AssayID");
        this.famAllele = data.get("A1");
        this.vicAllele = data.get("A2");
        this.snpId = data.get("SnpId");
        this.chromosome = data.get("Chr");
        this.position = data.get("Position");
    }

    @Override
    public void validate() throws Exception {
        if (null == this.assayId) {
            throw new NullPointerException("AssayID has not been set");
        }
    }

    public BimEntry toBimEntry() {
        BimEntry be = new BimEntry();
        be.setSnpId(this.snpId);
        be.setDistance("0");
        be.setChromosome(this.chromosome);
        be.setPosition(this.position);
        be.setAllele1(this.famAllele);
        be.setAllele1(this.vicAllele);
        return be;
    }

    public MapEntry toMapEntry() {
        MapEntry be = new MapEntry();
        be.setSnpId(this.snpId);
        be.setDistance("0");
        be.setChromosome(this.chromosome);
        be.setPosition(this.position);
        return be;
    }

    public String getFamGenotype() {
        return this.famAllele + " " + this.famAllele;
    }

    public String getVicGenotype() {
        return this.vicAllele + " " + this.vicAllele;
    }

    public String getBothGenotype() {
        return this.famAllele + " " + this.vicAllele;
    }

    public void toCallFormat(StringBuilder sb) {
        sb.append(this.assayId).append("\t").append(this.snpId).append("\t").append(this.famAllele).append(" ").append(this.vicAllele);
    }

    public void toMapFormat(StringBuilder sb) {
        sb.append(this.chromosome).append("\t").append(this.snpId).append("\t0\t").append(this.position);
    }

    public String getAssayId() {
        return this.assayId;
    }

    public void setAssayId(String assayId) {
        this.assayId = assayId;
    }

    public String getSnpId() {
        return this.snpId;
    }

    public void setSnpId(String snpId) {
        this.snpId = snpId;
    }

    public String getFamAllele() {
        return this.famAllele;
    }

    public void setFamAllele(String famAllele) {
        this.famAllele = famAllele;
    }

    public String getVicAllele() {
        return this.vicAllele;
    }

    public void setVicAllele(String vicAllele) {
        this.vicAllele = vicAllele;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public void setChromosome(String chromosome) {
        this.chromosome = chromosome;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }
}

