/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.taqman;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.taqman.AssayMetadata;

public class AssayMetadataIndex {
    public static final Logger LOGGER = LoggerFactory.getLogger(AssayMetadataIndex.class);
    protected Map<String, AssayMetadata> byAssayId = new HashMap<String, AssayMetadata>();
    protected Map<String, List<AssayMetadata>> bySnpId = new HashMap<String, List<AssayMetadata>>();

    public int size() {
        return this.byAssayId.size();
    }

    public void addAll(Collection<AssayMetadata> col) {
        for (AssayMetadata am : col) {
            this.add(am);
        }
    }

    public void add(AssayMetadata am) {
        if (null == am.getAssayId() || am.getAssayId().isEmpty()) {
            throw new RuntimeException("Cannot have a Null or Empty AssayId");
        }
        AssayMetadata prev = this.byAssayId.put(am.getAssayId().toUpperCase(), am);
        if (null != prev) {
            Formatter f = new Formatter().format("Found a duplicate AssayID %s while building the Assay Index. This later entry will replace the earlier entry: %s", am.getAssayId(), prev);
            LOGGER.warn(f.toString());
        }
        this.registerSnp(am);
    }

    protected void registerSnp(AssayMetadata am) {
        if (null == am.getSnpId() || am.getSnpId().isEmpty()) {
            return;
        }
        List<AssayMetadata> lst = this.bySnpId.get(am.getSnpId().toUpperCase());
        if (null == lst) {
            lst = new ArrayList<AssayMetadata>();
            this.bySnpId.put(am.getSnpId().toUpperCase(), lst);
        }
        lst.add(am);
    }

    public AssayMetadata get(String id) throws AssayNotFoundException, IdClashException {
        AssayMetadata am = this.byAssayId.get(id.toUpperCase());
        if (null != am) {
            return am;
        }
        List<AssayMetadata> lst = this.bySnpId.get(id.toUpperCase());
        if (null != lst) {
            if (lst.size() == 1) {
                return lst.get(0);
            }
            Formatter f = new Formatter();
            f.format("Looking for a unique mapping to SNP id %s but found %s", id, lst.size());
            throw new IdClashException(f.toString());
        }
        Formatter f = new Formatter();
        f.format("Could not find an assay using id '%s'", id);
        throw new AssayNotFoundException(f.toString());
    }

    public class IdClashException
    extends RuntimeException {
        public IdClashException(String msg) {
            super(msg);
        }
    }

    public class AssayNotFoundException
    extends RuntimeException {
        public AssayNotFoundException(String msg) {
            super(msg);
        }
    }
}

