/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.taqman;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.ped.FamEntry;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;
import uk.ac.ox.well.t2d.async.taqman.AssayMetadata;
import uk.ac.ox.well.t2d.async.taqman.SdsGenotype;
import uk.ac.ox.well.t2d.async.taqman.SdsGenotypeCounts;
import uk.ac.ox.well.t2d.async.taqman.SdsMetrics;

public abstract class ResultAggregator
extends AbstractConveyor<Context, List, List> {
    public static final Logger LOGGER = LoggerFactory.getLogger(ResultAggregator.class);

    public ResultAggregator() {
        this.setPayloadManager(new CollectionFactory.ListFactory());
    }

    @Override
    protected Context newContext() {
        return new Context();
    }

    public abstract void aggregate(Map var1, SdsGenotype var2);

    public abstract void format(Map var1, List var2);

    public static class SnpMetricsSummarizer
    extends ResultAggregator {
        @Override
        public void aggregate(Map map, SdsGenotype sgr) {
            SdsGenotypeCounts gm = (SdsGenotypeCounts)sgr;
            String id = gm.getAssayMetadata().getSnpId() + "|" + gm.getAssayMetadata().getAssayId();
            SdsMetrics metrics = (SdsMetrics)map.get(id);
            if (null == metrics) {
                metrics = new SdsMetrics(id);
                map.put(id, metrics);
            }
            metrics.inc(gm);
        }

        @Override
        public void format(Map map, List po) {
            po.add(new SdsMetrics.Header());
            po.addAll(map.values());
        }
    }

    public static class IndividualMetricsSummarizer
    extends ResultAggregator {
        @Override
        public void aggregate(Map map, SdsGenotype sgr) {
            SdsGenotypeCounts gm = (SdsGenotypeCounts)sgr;
            SdsMetrics metrics = (SdsMetrics)map.get(gm.getSampleId());
            if (null == metrics) {
                metrics = new SdsMetrics(gm.getSampleId());
                map.put(gm.getSampleId(), metrics);
            }
            metrics.inc(gm);
        }

        @Override
        public void format(Map map, List po) {
            po.add(new SdsMetrics.Header());
            po.addAll(map.values());
        }
    }

    public static class GenotypeAggregator
    extends ResultAggregator {
        @Override
        public void aggregate(Map map, SdsGenotype sgr) {
            ArrayList<SdsGenotype> list = (ArrayList<SdsGenotype>)map.get(sgr.getSampleId());
            if (null == list) {
                list = new ArrayList<SdsGenotype>(5);
                map.put(sgr.getSampleId(), list);
            }
            list.add(sgr);
        }

        @Override
        public void format(Map map, List po) {
            for (Object o : map.values()) {
                List list = (List)o;
                SdsGenotype gts = this.mergeCalls(list);
                po.add(gts);
            }
        }

        public SdsGenotype mergeCalls(List list) {
            List gtList = list;
            SdsGenotypeCounts gt = new SdsGenotypeCounts((SdsGenotype)gtList.get(0));
            gt.mergeAll(gtList);
            return gt;
        }
    }

    public static class MapAggregator
    extends ResultAggregator {
        @Override
        public void aggregate(Map map, SdsGenotype sgr) {
            AssayMetadata am = sgr.getAssayMetadata();
            map.put(am.getAssayId(), am);
        }

        @Override
        public void format(Map map, List list) {
            Iterator i$ = map.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry e = o = i$.next();
                AssayMetadata am = (AssayMetadata)e.getValue();
                list.add(am.toMapEntry());
            }
        }
    }

    public static class FamAggregator
    extends ResultAggregator {
        @Override
        public void aggregate(Map map, SdsGenotype sgr) {
            map.put(sgr.getSampleId(), sgr.getSampleId());
        }

        @Override
        public void format(Map map, List list) {
            for (Object str : map.keySet()) {
                FamEntry fam = new FamEntry();
                fam.basicSetup(str.toString());
                list.add(fam);
            }
        }
    }

    public class Context
    extends ProcessingContext<List, List> {
        Map<Object, Object> map;

        @Override
        protected void initialize() throws Exception {
            this.map = new TreeMap<Object, Object>();
        }

        @Override
        public void clear() {
            super.clear();
            this.map.clear();
        }

        @Override
        public ProcessingResult process(List pi, List po, boolean endOfContract) {
            for (Object o : pi) {
                SdsGenotype sgr = (SdsGenotype)o;
                ResultAggregator.this.aggregate(this.map, sgr);
            }
            if (endOfContract) {
                ResultAggregator.this.format(this.map, po);
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }
    }
}

