/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.taqman;

import java.util.Collection;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.metadata.MdataLdrBlock;
import uk.ac.ox.well.t2d.async.parser.ListTransformer;
import uk.ac.ox.well.t2d.async.taqman.SdsGenotype;
import uk.ac.ox.well.t2d.async.taqman.rig.SeriesBlock;

public class SdsExclusionBlock
extends SeriesBlock {
    public static final String SNP_EXCLUSION_PATH_KEY = "snpExclusionPath";
    public static final String SNP_EXCLUSION_SET_KEY = "snpExclusionSet";
    public static final String SAMPLE_EXCLUSION_PATH_KEY = "sampleExclusionPath";
    public static final String SAMPLE_EXCLUSION_SET_KEY = "sampleExclusionSet";

    public SdsExclusionBlock() {
        MdataLdrBlock.MdataSetLdrBlock snpLdr = new MdataLdrBlock.MdataSetLdrBlock();
        snpLdr.setInputPropertyKey(SNP_EXCLUSION_PATH_KEY);
        snpLdr.setOutputPropertyKey(SNP_EXCLUSION_SET_KEY);
        MdataLdrBlock.MdataSetLdrBlock sampleLdr = new MdataLdrBlock.MdataSetLdrBlock();
        sampleLdr.setInputPropertyKey(SAMPLE_EXCLUSION_PATH_KEY);
        sampleLdr.setOutputPropertyKey(SAMPLE_EXCLUSION_SET_KEY);
        this.addProcessor(snpLdr);
        this.addProcessor(sampleLdr);
    }

    public static class SdsCallExcluder
    extends ListTransformer {
        @Override
        protected ListTransformer.Context newContext() {
            return new SdsCallContext();
        }

        public class SdsCallContext
        extends ListTransformer.Context {
            Set<String> snpExclusions;
            Set<String> sampleExclusions;
            Set<String> snpsExcluded = new HashSet<String>();
            Set<String> samplesExcluded = new HashSet<String>();
            int exclusionCount = 0;

            @Override
            public void initialize() {
                this.snpExclusions = (Set)this.getContract().get(SdsExclusionBlock.SNP_EXCLUSION_SET_KEY);
                this.sampleExclusions = (Set)this.getContract().get(SdsExclusionBlock.SAMPLE_EXCLUSION_SET_KEY);
                if (this.getLogger().isInfoEnabled()) {
                    Formatter f = new Formatter();
                    if (null == this.snpExclusions && null == this.sampleExclusions) {
                        f.format("No SNP or sample exclusions found", new Object[0]);
                    } else {
                        f.format("Found %d SNP exclusions, %d sample exclusions", this.size(this.snpExclusions), this.size(this.sampleExclusions));
                    }
                    this.getLogger().info(f.toString());
                }
            }

            protected int size(Collection c) {
                if (null == c) {
                    return 0;
                }
                return c.size();
            }

            @Override
            public void clear() {
                this.snpExclusions = null;
                this.sampleExclusions = null;
                this.snpsExcluded.clear();
                this.samplesExcluded.clear();
                this.exclusionCount = 0;
            }

            @Override
            public ProcessingResult process(List pi, List po, boolean endOfContract) {
                List sdsIn = pi;
                for (SdsGenotype record : sdsIn) {
                    boolean exclude = false;
                    if (null != this.sampleExclusions && this.sampleExclusions.contains(record.getSampleId())) {
                        this.samplesExcluded.add(record.getSampleId());
                        exclude = true;
                    }
                    if (null != this.snpExclusions && this.snpExclusions.contains(record.getAssayMetadata().getSnpId())) {
                        this.snpsExcluded.add(record.getAssayMetadata().getSnpId());
                        exclude = true;
                    }
                    if (exclude) {
                        ++this.exclusionCount;
                        continue;
                    }
                    po.add(record);
                }
                if (endOfContract && this.getLogger().isInfoEnabled()) {
                    Formatter f = new Formatter();
                    if (null != this.snpExclusions || null != this.sampleExclusions) {
                        f.format("Applied %d excluded SNPs and %d excluded samples, in total %d calls were excluded", this.snpsExcluded.size(), this.samplesExcluded.size(), this.exclusionCount);
                    }
                    this.getLogger().info(f.toString());
                }
                return ProcessingResult.BOTH_COMPLETE;
            }
        }
    }
}

