/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.taqman;

import java.util.Formatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.taqman.AssayMetadata;
import uk.ac.ox.well.t2d.async.taqman.SdsMetadata;

public class SdsGenotype {
    public static final Logger LOGGER = LoggerFactory.getLogger(SdsGenotype.class);
    private AssayMetadata assayMetadata;
    private String sampleId;
    private SdsCall call;

    public SdsGenotype() {
    }

    public SdsGenotype(SdsGenotype sgc) {
        this.assayMetadata = sgc.assayMetadata;
        this.sampleId = sgc.sampleId;
        this.call = sgc.call;
    }

    public void load(AssayMetadata am, SdsMetadata sm, Map<String, String> recordData) {
        this.setAssayMetadata(am);
        String rawSampleId = recordData.get("Sample Name");
        if (rawSampleId.contains("|")) {
            rawSampleId = rawSampleId.split("\\|")[0];
        }
        this.setSampleId(rawSampleId);
        this.setCall(recordData.get("Call").trim());
    }

    public void setCall(String str) {
        switch (str) {
            case "AlleleX-FAM": {
                this.setCall(SdsCall.FAM);
                break;
            }
            case "AlleleY-VIC": {
                this.setCall(SdsCall.VIC);
                break;
            }
            case "Both": {
                this.setCall(SdsCall.BOTH);
                break;
            }
            default: {
                this.setCall(SdsCall.NC);
            }
        }
    }

    public String getGenotype() {
        switch (this.getCall()) {
            case FAM: {
                return this.getAssayMetadata().getFamGenotype();
            }
            case VIC: {
                return this.getAssayMetadata().getVicGenotype();
            }
            case BOTH: {
                return this.getAssayMetadata().getBothGenotype();
            }
        }
        return "0 0";
    }

    public boolean isNoCall() {
        return SdsCall.NC.equals((Object)this.getCall());
    }

    public boolean isDisputed() {
        return SdsCall.DISP.equals((Object)this.getCall());
    }

    public void merge(SdsGenotype other) {
        if (null == this.getCall()) {
            this.setCall(other.getCall());
        } else if (!SdsCall.NC.equals((Object)other.getCall())) {
            if (SdsCall.NC.equals((Object)this.getCall())) {
                this.setCall(other.getCall());
            } else if (!SdsCall.DISP.equals((Object)this.getCall()) && !this.getCall().equals((Object)other.getCall())) {
                Formatter f = new Formatter().format("Found a disputed call while merging genotypes. Assay=%s, Sample=%s, call1=%s, call2=%s\n", new Object[]{this.assayMetadata.getAssayId(), this.sampleId, this.getCall(), other.getCall()});
                LOGGER.info(f.toString());
                this.setCall(SdsCall.DISP);
            }
        }
    }

    public void mergeAll(List<? extends SdsGenotype> list) {
        for (SdsGenotype sdsGenotype : list) {
            this.merge(sdsGenotype);
        }
    }

    public StringBuilder toStringBuilder() {
        StringBuilder sb = new StringBuilder();
        this.getAssayMetadata().toCallFormat(sb);
        sb.append("\t");
        sb.append(this.sampleId).append("\t");
        sb.append((Object)this.call).append("\t");
        sb.append(this.getGenotype());
        return sb;
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    public AssayMetadata getAssayMetadata() {
        return this.assayMetadata;
    }

    public void setAssayMetadata(AssayMetadata assayMetadata) {
        this.assayMetadata = assayMetadata;
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(String sampleId) {
        this.sampleId = sampleId;
    }

    public SdsCall getCall() {
        return this.call;
    }

    public void setCall(SdsCall call) {
        this.call = call;
    }

    public PedView toPedView() {
        return new PedView();
    }

    public MapView toMapView() {
        return new MapView();
    }

    public LgenView toLgenView() {
        return new LgenView();
    }

    public class LgenView {
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(SdsGenotype.this.sampleId).append("\t");
            sb.append(SdsGenotype.this.sampleId).append("\t");
            sb.append(SdsGenotype.this.getAssayMetadata().getSnpId()).append("\t");
            sb.append(SdsGenotype.this.getGenotype());
            return sb.toString();
        }
    }

    public class MapView {
        public String toString() {
            StringBuilder sb = new StringBuilder();
            SdsGenotype.this.getAssayMetadata().toMapFormat(sb);
            return sb.toString();
        }
    }

    public class PedView {
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(SdsGenotype.this.sampleId).append("\t");
            sb.append(SdsGenotype.this.sampleId).append("\t");
            sb.append("0\t0\t-9\t-9\t");
            sb.append(SdsGenotype.this.getGenotype());
            return sb.toString();
        }
    }

    public static enum SdsCall {
        FAM,
        VIC,
        BOTH,
        NC,
        DISP;

    }
}

