/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.taqman;

import java.math.BigDecimal;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.CallMetrics;
import uk.ac.ox.well.t2d.async.taqman.SdsGenotypeCounts;

public class SdsMetrics {
    private String id;
    private SdsCallMetrics raw;
    private SdsCallMetrics merged;
    private int disputed;

    public SdsMetrics(String sid) {
        this.id = sid;
        this.raw = new SdsCallMetrics();
        this.merged = new SdsCallMetrics();
        this.disputed = 0;
    }

    public void inc(SdsGenotypeCounts metrics) {
        this.raw.incRaw(metrics);
        switch (metrics.getCall()) {
            case FAM: {
                this.merged.inc(BedConstants.Call.HOM1);
                break;
            }
            case BOTH: {
                this.merged.inc(BedConstants.Call.HET);
                break;
            }
            case VIC: {
                this.merged.inc(BedConstants.Call.HOM2);
                break;
            }
            case DISP: {
                ++this.disputed;
                break;
            }
            case NC: {
                this.merged.inc(BedConstants.Call.NC);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public BigDecimal getMissingness() {
        return this.merged.getQuotient(this.merged.getNc(), this.merged.getTotalCalls() + this.disputed);
    }

    public BigDecimal getMissingnessIncluDisputes() {
        return this.merged.getQuotient(this.merged.getNc() + this.disputed, this.merged.getTotalCalls() + this.disputed);
    }

    public String toString() {
        return this.toStringBuilder("\t").toString();
    }

    public StringBuilder toStringBuilder(String sep) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id);
        sb.append(sep);
        this.raw.write(sep, sb);
        sb.append(sep);
        sb.append(this.raw.getMissingness().toPlainString());
        sb.append(sep);
        this.merged.write(sep, sb);
        sb.append(sep);
        sb.append(this.disputed);
        sb.append(sep);
        sb.append(this.getMissingness().toPlainString());
        sb.append(sep);
        sb.append(this.getMissingnessIncluDisputes().toPlainString());
        return sb;
    }

    public static class SdsCallMetrics
    extends CallMetrics {
        public void incRaw(SdsGenotypeCounts metrics) {
            this.hom1 += metrics.getFamCount();
            this.het += metrics.getBothCount();
            this.hom2 += metrics.getVicCount();
            this.nc += metrics.getNcCount();
        }
    }

    public static class Header
    extends SdsCallMetrics {
        @Override
        public StringBuilder toStringBuilder(String sep) {
            StringBuilder sb = new StringBuilder();
            sb.append("ID");
            sb.append(sep);
            sb.append("RAW_FAM");
            sb.append(sep);
            sb.append("RAW_BOTH");
            sb.append(sep);
            sb.append("RAW_VIC");
            sb.append(sep);
            sb.append("RAW_NC");
            sb.append(sep);
            sb.append("RAW_MISSING");
            sb.append(sep);
            sb.append("MERGD_FAM");
            sb.append(sep);
            sb.append("MERGD_BOTH");
            sb.append(sep);
            sb.append("MERGD_VIC");
            sb.append(sep);
            sb.append("MERGD_NC");
            sb.append(sep);
            sb.append("MERGD_DISP");
            sb.append(sep);
            sb.append("MERGD_MISSING");
            sb.append(sep);
            sb.append("MERGD_MISSING_PLUS_DISP");
            return sb;
        }
    }
}

