/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.taqman;

import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.contracts.Demultiplexer;
import uk.ac.ox.well.t2d.async.io.AsynchronousFileChannelReader;
import uk.ac.ox.well.t2d.async.io.CharacterDecoder;
import uk.ac.ox.well.t2d.async.parser.CsvParsingLogic;
import uk.ac.ox.well.t2d.async.parser.ListTransformer;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.taqman.AssayMetadataIndexLdrBlck;
import uk.ac.ox.well.t2d.async.taqman.ResultAggregator;
import uk.ac.ox.well.t2d.async.taqman.SdsExclusionBlock;
import uk.ac.ox.well.t2d.async.taqman.SdsGenotype;
import uk.ac.ox.well.t2d.async.taqman.SdsRecord;
import uk.ac.ox.well.t2d.async.taqman.SdsTableHandler;
import uk.ac.ox.well.t2d.async.taqman.rig.DirScanMplxrBlock;
import uk.ac.ox.well.t2d.async.taqman.rig.MplxrListWritingBlock;
import uk.ac.ox.well.t2d.async.taqman.rig.PathScanSerialMplxrBlock;
import uk.ac.ox.well.t2d.async.taqman.rig.SeriesBlock;

public class SdsProcessingBlock
extends SeriesBlock {
    public static final Pattern OXGN_PATTERN = Pattern.compile("(OXGN-\\d*).*");
    public static final Pattern SNP_DIR_PATTERN = Pattern.compile("^(rs\\d+)-.*$");
    private DirectoryFacilitator directoryFacilitator;
    private SampleNameTransformer sampleNameTransformer;

    public SdsProcessingBlock() {
        this(true);
    }

    public SdsProcessingBlock(boolean loadAssayInfo) {
        if (loadAssayInfo) {
            AssayMetadataIndexLdrBlck amilb = new AssayMetadataIndexLdrBlck();
            this.addProcessor(amilb);
        }
        this.addProcessor(new SdsExclusionBlock());
        DirScanMplxrBlock dirScnBlck = new DirScanMplxrBlock();
        dirScnBlck.getDirScnnr().setMaxDepth(2);
        this.addProcessor(dirScnBlck);
        this.directoryFacilitator = new DirectoryFacilitator();
        this.addProcessor(this.directoryFacilitator);
        PathScanSerialMplxrBlock pathMplxr = new PathScanSerialMplxrBlock();
        pathMplxr.getPathScanner().addPattern("glob:**.{txt}");
        this.addProcessor(pathMplxr);
        SdsParsingBlock sds = new SdsParsingBlock();
        this.addProcessor(sds);
        this.sampleNameTransformer = new SampleNameTransformer();
        this.addProcessor(this.sampleNameTransformer);
        Demultiplexer fileDplxr = new Demultiplexer();
        this.addProcessor(fileDplxr);
        ResultAggregator.GenotypeAggregator genoAgg = new ResultAggregator.GenotypeAggregator();
        this.addProcessor(genoAgg);
        this.addProcessor(new Demultiplexer());
        SdsExclusionBlock.SdsCallExcluder excluder = new SdsExclusionBlock.SdsCallExcluder();
        this.addProcessor(excluder);
        SdsFormattingBlock frmttrBlock = new SdsFormattingBlock();
        this.addProcessor(frmttrBlock);
    }

    public DirectoryFacilitator getDirectoryFacilitator() {
        return this.directoryFacilitator;
    }

    public static class LgenTransformer
    extends ListTransformer {
        public LgenTransformer() {
            this.setPayloadManager(new CollectionFactory.ListFactory());
        }

        @Override
        public Object transform(Object o) {
            SdsGenotype sgr = (SdsGenotype)o;
            return sgr.toLgenView();
        }
    }

    public static class SdsFormattingBlock
    extends MplxrListWritingBlock {
        public SdsFormattingBlock() {
            this.addFormatter(new LgenTransformer(), "lgen");
            this.addFormatter(new ResultAggregator.FamAggregator(), "fam");
            this.addFormatter(new ResultAggregator.MapAggregator(), "map");
            this.addFormatter(new ResultAggregator.IndividualMetricsSummarizer(), "ind_metrics");
            this.addFormatter(new ResultAggregator.SnpMetricsSummarizer(), "snp_metrics");
        }
    }

    public static class SdsParser
    extends TableParser<List> {
        public SdsParser() {
            this.setPayloadManager(new CollectionFactory.ListFactory());
        }

        @Override
        protected TableParsingLogic<List> newLogic() {
            CsvParsingLogic atp = new CsvParsingLogic();
            atp.setCellSeparator('\t');
            return atp;
        }

        @Override
        protected TableCellHandler<List> newHandler() {
            return new SdsTableHandler();
        }
    }

    public static class SdsParsingBlock
    extends SeriesBlock {
        AsynchronousFileChannelReader cr = new AsynchronousFileChannelReader();
        CharacterDecoder cd = new CharacterDecoder();
        SdsParser sds = new SdsParser();

        public SdsParsingBlock() {
            super.addProcessor(this.cr);
            super.addProcessor(this.cd);
            super.addProcessor(this.sds);
        }

        public SdsParser getSdsParser() {
            return this.sds;
        }
    }

    public class DirectoryFacilitator
    extends BasicProcessor {
        Pattern snp_dir_pattern = SNP_DIR_PATTERN;

        public void setSnpDirPattern(Pattern p) {
            this.snp_dir_pattern = p;
        }

        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            Path path = (Path)bin.getPayload();
            this.transform(c, path);
            this.getProcessor().consume(c, bin, endOfInput);
        }

        public void transform(Contract c, Path p) {
            String raw = p.getFileName().toString();
            Matcher m = this.snp_dir_pattern.matcher(raw);
            if (m.find()) {
                String snp = m.group(1);
                c.put("SdsTableHandler.SnpId", snp);
                this.logger.info("Found SNP directory with ID: " + snp);
            } else {
                this.logger.info("Did not find a matching pattern for SNP directory. Continuing run with raw dir name: " + raw);
                c.put("SdsTableHandler.SnpId", raw);
            }
        }
    }

    public class SampleNameTransformer
    extends ListTransformer {
        @Override
        public Object transform(Object o) {
            SdsRecord sgr = (SdsRecord)o;
            String sampleId = sgr.getSampleId();
            if (sampleId.startsWith("OXGN")) {
                Matcher m1 = OXGN_PATTERN.matcher(sampleId);
                if (m1.matches()) {
                    sampleId = m1.group(1);
                }
            } else if (sampleId.startsWith("WTD") && !sampleId.contains("-O-")) {
                sampleId = sampleId.replace("O-", "-O-");
            }
            sampleId = sampleId.trim();
            sampleId = sampleId.replaceAll("\\s", "_");
            sgr.setSampleId(sampleId);
            return sgr;
        }
    }
}

