/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.taqman.rig;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Node;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.taqman.rig.Configurator;

public class SeriesBlock
extends Configurator
implements Node {
    protected Deque<Node> processors = new ArrayDeque<Node>();

    public void addProcessor(Node node) {
        this.processors.add(node);
    }

    @Override
    public void commence() {
        this.commenceAll(this.processors);
    }

    protected void commenceAll(Collection<Node> ps) {
        for (Node proc : ps) {
            this.configure(proc);
        }
        Node previousNode = null;
        for (Node proc : ps) {
            if (null != previousNode) {
                previousNode.setProcessor(proc);
            }
            previousNode = proc;
            proc.commence();
        }
    }

    @Override
    public void close() {
        for (Node proc : this.processors) {
            proc.close();
        }
    }

    @Override
    public void consume(Contract c, Bucket bin, boolean endOfInput) {
        this.processors.getFirst().consume(c, bin, endOfInput);
    }

    public void setProcessor(Processor processor) {
        this.processors.getLast().setProcessor(processor);
    }
}

