/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.testing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.contracts.Contractor;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.taqman.rig.SeriesBlock;

public class ExecutionRig
extends HashMap<String, Object> {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExecutionRig.class.getName());
    public static final String THREAD_COUNT_KEY = "execution.thread_count";
    public static final String BUCKET_COUNT_KEY = "execution.bucket_count";
    public static final String BUFFER_CAPACITY_KEY = "execution.buffer_capacity";
    protected int threadCount = 2;
    protected int bucketCount = 10;
    protected int bufferCapacity = 10000;
    protected SeriesBlock blck;

    public ExecutionRig() {
        LOGGER.info("Constructed...");
    }

    public ExecutionRig(SeriesBlock sb) {
        this();
        this.blck = sb;
    }

    public void initialize(String propertiesPath, String defaultPropertiesPath) throws IOException {
        Properties props = this.loadProperties(propertiesPath);
        Properties defaultProps = this.loadProperties(defaultPropertiesPath);
        if (null == props) {
            String error = "Main Properties path not supplied. At least one properties file must be specified.";
            LOGGER.error(error);
            throw new RuntimeException(error);
        }
        if (null == defaultProps) {
            LOGGER.info("Default Properties path not supplied");
        }
        this.initialize(props, defaultProps);
    }

    public void initialize(Properties properties, Properties defaultProperties) {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        if (null != defaultProperties) {
            m.putAll(defaultProperties);
        }
        if (null != properties) {
            m.putAll(properties);
        }
        this.initialize(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(String path) throws IOException {
        if (null == path || path.isEmpty()) {
            return null;
        }
        Properties p = new Properties();
        File f = new File(path);
        if (f.exists()) {
            try (FileInputStream fis = new FileInputStream(f);){
                p.load(fis);
            }
            return p;
        }
        throw new FileNotFoundException("Could not find Properties file '" + f.getPath() + "'. Accessing at canonical path: " + "" + f.getCanonicalPath());
    }

    public void initialize(Map p) {
        String bufferCapacityStr;
        String bucketCountStr;
        String threadCountStr;
        if (p.isEmpty()) {
            LOGGER.warn("No Properties found during initialization.");
        }
        if (null != (threadCountStr = (String)p.get(THREAD_COUNT_KEY))) {
            this.threadCount = Integer.parseInt(threadCountStr);
        }
        if (null != (bucketCountStr = (String)p.get(BUCKET_COUNT_KEY))) {
            this.bucketCount = Integer.parseInt(bucketCountStr);
        }
        if (null != (bufferCapacityStr = (String)p.get(BUFFER_CAPACITY_KEY))) {
            this.bufferCapacity = Integer.parseInt(bufferCapacityStr);
        }
        this.putAll(p);
        LOGGER.info("Initialized...");
    }

    public PrimaryContract execute(SeriesBlock block) throws Exception {
        LOGGER.info("Executing...");
        this.logState();
        ExecutorService es = Executors.newFixedThreadPool(this.getThreadCount());
        block.setExecutorService(es);
        block.setBucketCount(this.getBucketCount());
        block.setBufferCapacity(this.getBufferCapacity());
        block.commence();
        Contractor c = new Contractor();
        c.setStartPoint(block);
        c.setEndPoint(block);
        long start = System.currentTimeMillis();
        try {
            PrimaryContract pc = c.initiate(null, this);
            long end = System.currentTimeMillis();
            LOGGER.info(new Formatter().format("Execution complete in %,d ms%n", end - start).toString());
            PrimaryContract primaryContract = pc;
            return primaryContract;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            block.close();
            es.shutdown();
        }
    }

    public PrimaryContract execute() throws Exception {
        if (null == this.blck) {
            throw new RuntimeException("Execute() cannot be used because no block was specified.");
        }
        return this.execute(this.blck);
    }

    public void logState() {
        LOGGER.info(new Formatter().format("ThreadCount=%d, BucketCount=%d, BufferCapacity=%d", this.threadCount, this.bucketCount, this.bufferCapacity).toString());
        LOGGER.info(new Formatter().format("Properties: %s", this).toString());
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public void setBucketCount(int bucketCount) {
        this.bucketCount = bucketCount;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public void setBufferCapacity(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }
}

