/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.testing;

import java.util.Random;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;
import uk.ac.ox.well.t2d.async.processors.CommandQueue;
import uk.ac.ox.well.t2d.async.processors.NullPayloadManager;
import uk.ac.ox.well.t2d.async.processors.SerialCommandQueue;

public class PassThroughConveyor
extends AbstractConveyor {
    private int maxWaitMs = 0;

    public PassThroughConveyor() {
        this((CommandQueue)new SerialCommandQueue());
    }

    public PassThroughConveyor(CommandQueue q) {
        super(q);
        this.setPayloadManager(new NullPayloadManager());
    }

    protected ProcessingContext newContext() {
        return new Context(this.getMaxWaitMs());
    }

    public int getMaxWaitMs() {
        return this.maxWaitMs;
    }

    public void setMaxWaitMs(int maxWaitMs) {
        this.maxWaitMs = maxWaitMs;
    }

    public class Context
    extends ProcessingContext {
        int waitMs;
        Random random = new Random();

        public Context() {
            this(50);
        }

        public Context(int ms) {
            this.waitMs = ms;
        }

        public ProcessingResult process(Object pi, Bucket po, boolean eoi) {
            po.setPayload(pi);
            if (0 < this.waitMs) {
                long r = this.random.nextInt(this.waitMs);
                try {
                    Thread.sleep(r);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            return ProcessingResult.BOTH_COMPLETE;
        }
    }
}

