/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.vcf;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.CharSequenceRegulator;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.vcf.VcfException;
import uk.ac.ox.well.t2d.async.vcf.VcfGenotypeHandler;
import uk.ac.ox.well.t2d.async.vcf.VcfMetadata;
import uk.ac.ox.well.t2d.async.vcf.VcfPosition;

public class VcfHandler
extends TableCellHandlerBase<CharBuffer> {
    protected CharSequenceRegulator reg = new CharSequenceRegulator();
    protected VcfMetadata metadata = new VcfMetadata();
    protected VcfSection section = VcfSection.METADATA;
    protected boolean hasFormatColumn = false;
    protected List<String> sampleIds;
    protected VcfPosition currentPosition = new VcfPosition();
    protected VcfGenotypeHandler gtHandler;

    public VcfHandler() {
        this.sampleIds = new ArrayList<String>();
    }

    public void setGenotypeHandler(VcfGenotypeHandler hdlr) {
        this.gtHandler = hdlr;
    }

    @Override
    public final boolean flush(Bucket<CharBuffer> bo) {
        this.reg.flush(bo.getPayload());
        if (!bo.getPayload().hasRemaining()) {
            bo.getPayload().flip();
            return true;
        }
        return false;
    }

    @Override
    public boolean startTable(Bucket<CharBuffer> bo) throws Exception {
        this.gtHandler.handleStart(this.getTableParsingContext().getContract());
        return super.startTable(bo);
    }

    @Override
    public final boolean endTable(Bucket<CharBuffer> bo) throws Exception {
        bo.getPayload().flip();
        return false;
    }

    @Override
    public final void clear() {
        this.reg.clear();
    }

    public String toString() {
        return this.reg.toString();
    }

    @Override
    public final boolean cell(TableCellMetadata cellMeta, CharArraySequence cellData, Bucket<CharBuffer> bo) throws Exception {
        if (VcfSection.METADATA == this.section) {
            if ('#' == cellData.charAt(0) && '#' == cellData.charAt(1)) {
                this.metadata.addMetadataCell(cellData.subSequence(2, cellData.length()));
            } else if (1L == cellMeta.getColumnNumber() && '#' == cellData.charAt(0)) {
                this.headerCell(cellMeta, cellData.subSequence(1, cellData.length()));
                this.section = VcfSection.HEADER;
                this.gtHandler.handleVcfMetadata(this.metadata);
            }
        } else if (VcfSection.HEADER == this.section) {
            this.headerCell(cellMeta, cellData);
            if (cellMeta.isEndOfLine()) {
                this.section = VcfSection.BODY;
            }
        } else if (VcfSection.BODY == this.section) {
            this.bodyCell(cellMeta, cellData);
            if (cellMeta.isEndOfLine()) {
                this.currentPosition.clear();
            }
        }
        this.reg.flush(bo.getPayload());
        if (!bo.getPayload().hasRemaining()) {
            bo.getPayload().flip();
            return true;
        }
        return false;
    }

    public void bodyCell(TableCellMetadata cellMeta, CharArraySequence cellData) throws VcfException {
        int column = (int)cellMeta.getColumnNumber();
        switch (column) {
            case 1: {
                this.currentPosition.setChrom(cellData);
                break;
            }
            case 2: {
                this.currentPosition.setPos(cellData);
                break;
            }
            case 3: {
                this.currentPosition.setId(cellData);
                break;
            }
            case 4: {
                this.currentPosition.setRef(cellData);
                break;
            }
            case 5: {
                this.currentPosition.setAlt(cellData);
                break;
            }
            case 6: {
                this.currentPosition.setQual(cellData);
                break;
            }
            case 7: {
                this.currentPosition.setFilter(cellData);
                break;
            }
            case 8: {
                this.currentPosition.setInfo(cellData);
                break;
            }
            case 9: {
                if (this.hasFormatColumn) {
                    this.currentPosition.setFormat(cellData);
                    this.gtHandler.handlePosition(this.currentPosition, this.reg);
                    break;
                }
                this.currentPosition.setFormat(cellData);
                this.dataCell(cellMeta, cellData);
                break;
            }
            default: {
                this.dataCell(cellMeta, cellData);
            }
        }
    }

    public void headerCell(TableCellMetadata cellMeta, CharArraySequence cellData) throws VcfException {
        int column = (int)cellMeta.getColumnNumber();
        switch (column) {
            case 1: {
                this.validateFixedHeader("CHROM", cellData, cellMeta);
                break;
            }
            case 2: {
                this.validateFixedHeader("POS", cellData, cellMeta);
                break;
            }
            case 3: {
                this.validateFixedHeader("ID", cellData, cellMeta);
                break;
            }
            case 4: {
                this.validateFixedHeader("REF", cellData, cellMeta);
                break;
            }
            case 5: {
                this.validateFixedHeader("ALT", cellData, cellMeta);
                break;
            }
            case 6: {
                this.validateFixedHeader("QUAL", cellData, cellMeta);
                break;
            }
            case 7: {
                this.validateFixedHeader("FILTER", cellData, cellMeta);
                break;
            }
            case 8: {
                this.validateFixedHeader("INFO", cellData, cellMeta);
                break;
            }
            case 9: {
                if (this.equals(cellData, "FORMAT")) {
                    this.hasFormatColumn = true;
                    break;
                }
                this.addSampleId(cellData);
                break;
            }
            default: {
                this.addSampleId(cellData);
            }
        }
    }

    public int getFixedFieldCount() {
        if (this.hasFormatColumn) {
            return 9;
        }
        return 8;
    }

    public void validateFixedHeader(String str, CharArraySequence cas, TableCellMetadata cellMet) throws VcfException {
        if (!this.equals(cas, str)) {
            Formatter f = new Formatter();
            f.format("Expecting header value %s at column %d. Found: %s", str, cellMet.getColumnNumber(), cas);
            throw new VcfException(f.toString());
        }
    }

    public boolean equals(CharArraySequence cas, String str) {
        return cas.toString().equals(str);
    }

    public void dataCell(TableCellMetadata cellMeta, CharArraySequence cellData) throws VcfException {
        this.gtHandler.handleCellMetadata(this.getSampleId(cellMeta), cellMeta);
        this.gtHandler.handleData(cellData, this.reg);
    }

    public String getSampleId(TableCellMetadata cellMeta) throws VcfException {
        int columnNo = (int)cellMeta.getColumnNumber() - this.getFixedFieldCount();
        if (columnNo < 1 || columnNo > this.sampleIds.size()) {
            Formatter f = new Formatter();
            f.format("Column number is out of bounds. Number of headers %d. Found %d, line %d", this.sampleIds.size(), columnNo, cellMeta.getLineNumber());
            throw new VcfException(f.toString());
        }
        String id = this.sampleIds.get(columnNo - 1);
        if (null == id) {
            Formatter f = new Formatter();
            f.format("No sample id found for column number %d", columnNo);
            throw new VcfException(f.toString());
        }
        return id;
    }

    public void addSampleId(CharArraySequence cas) {
        this.sampleIds.add(cas.toString());
    }

    public static enum VcfSection {
        METADATA,
        HEADER,
        BODY;

    }
}

