/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.vcf;

import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import uk.ac.ox.well.t2d.async.vcf.VcfException;

public class VcfPosition {
    public static final Pattern COLON_PATTERN = Pattern.compile(":");
    public static final Pattern COMMA_PATTERN = Pattern.compile(",");
    public static final Pattern ALLELE_SEPARATOR_PATTERN = Pattern.compile("[/|]");
    public static final String GENOTYPE_KEY = "GT";
    public static final String GENOTYPE_LIKELIHOOD_KEY = "GL";
    public static final String GENOTYPE_QUALITY_KEY = "GQ";
    public static final String READ_DEPTH_KEY = "DP";
    private String chrom;
    private String pos;
    private String id;
    private String ref;
    private String alt;
    private String qual;
    private String filter;
    private String info;
    private Map<String, Integer> format = new LinkedHashMap<String, Integer>();

    public void clear() {
        this.chrom = null;
        this.pos = null;
        this.id = null;
        this.ref = null;
        this.alt = null;
        this.qual = null;
        this.filter = null;
        this.info = null;
        this.format.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.chrom).append("\t");
        sb.append(this.pos).append("\t");
        sb.append(this.id).append("\t");
        sb.append(this.ref).append("\t");
        sb.append(this.alt).append("\t");
        sb.append(this.getQual()).append("\t");
        sb.append(this.getFilter()).append("\t");
        sb.append(this.info).append("\t");
        sb.append(this.formatSubfields(this.format)).append("\t");
        return sb.toString();
    }

    public String getSubfieldString() {
        return this.formatSubfields(this.format);
    }

    public String formatSubfields(Map<String, Integer> format) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = format.keySet().iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    public void setChrom(CharSequence chrom) {
        this.chrom = chrom.toString();
    }

    public void setPos(CharSequence pos) {
        this.pos = pos.toString();
    }

    public void setId(CharSequence id) {
        this.id = id.toString();
    }

    public void setRef(CharSequence ref) {
        this.ref = ref.toString();
    }

    public void setAlt(CharSequence alt) {
        this.alt = alt.toString();
    }

    public void setQual(CharSequence qual) {
        this.qual = qual.toString();
    }

    public void setFilter(CharSequence filter) {
        this.filter = filter.toString();
    }

    public void setInfo(CharSequence info) {
        if (null != info) {
            this.info = info.toString();
        }
    }

    public void setFormat(CharSequence cs) {
        this.format.clear();
        String[] str = this.getSubFields(cs);
        for (int i = 0; i < str.length; ++i) {
            this.format.put(str[i], i);
        }
    }

    public String getChrom() {
        return this.chrom;
    }

    public String getPos() {
        return this.pos;
    }

    public String getChrPosString() {
        return this.chrom + "_" + this.pos;
    }

    public String getId() {
        return this.id;
    }

    public String getInfo() {
        return this.info;
    }

    public String getCall(String[] likelis, double log10Cutoff) throws VcfException {
        if (likelis.length > 0 && this.passesCutoff(likelis[0], log10Cutoff)) {
            return this.ref + " " + this.ref;
        }
        if (likelis.length > 1 && this.passesCutoff(likelis[1], log10Cutoff)) {
            return this.ref + " " + this.alt;
        }
        if (likelis.length > 2 && this.passesCutoff(likelis[2], log10Cutoff)) {
            return this.alt + " " + this.alt;
        }
        return "0 0";
    }

    public boolean passesCutoff(String number, double log10Cutoff) {
        double d = Double.parseDouble(number);
        return log10Cutoff <= d;
    }

    public String[] getGenotypeLikelihoods(String[] sf) throws VcfException {
        String str = this.getSubFieldValue(sf, GENOTYPE_LIKELIHOOD_KEY);
        String[] gts = COMMA_PATTERN.split(str);
        return gts;
    }

    public String[] getAlleles(String[] sf) throws VcfException {
        String str = this.getSubFieldValue(sf, GENOTYPE_KEY);
        String[] gts = ALLELE_SEPARATOR_PATTERN.split(str);
        for (int i = 0; i < gts.length; ++i) {
            this.recodeAllele(gts, i);
        }
        return gts;
    }

    public void recodeAllele(String[] gts, int index) {
        String original;
        String recoded = original = gts[index];
        switch (original) {
            case ".": {
                recoded = "0";
                break;
            }
            case "0": {
                recoded = this.getRef();
                break;
            }
            case "1": {
                recoded = this.getAlt();
            }
        }
        gts[index] = recoded;
    }

    public boolean isSubFieldPresent(String sfKey) {
        return this.format.containsKey(sfKey);
    }

    public String getSubFieldValue(String[] sf, String sfKey) throws VcfException {
        if (!this.isSubFieldPresent(sfKey)) {
            Formatter f = new Formatter();
            f.format("Expecting a FORMAT subfield key %s. Found %s.", this.format.keySet(), sfKey);
            throw new VcfException(f.toString());
        }
        if (!this.format.containsKey(sfKey)) {
            Formatter f = new Formatter();
            f.format("Found SubFieldValue %s, expecting one of: %s%n", sfKey, this.format);
            throw new VcfException(f.toString());
        }
        int index = this.format.get(sfKey);
        if (sf.length < index) {
            Formatter f = new Formatter();
            f.format("Found SubField Index %d, however this fields only has %s elements.%n", index, sf.length);
            throw new VcfException(f.toString());
        }
        return sf[index];
    }

    public String[] getSubFields(CharSequence cs) {
        return COLON_PATTERN.split(cs);
    }

    public String getRef() {
        return this.ref;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getQual() {
        return this.qual;
    }

    public String getFilter() {
        return this.filter;
    }
}

