/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.vcf.impl;

import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ox.well.t2d.async.io.CharBufferFactory;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.CharSequenceRegulator;
import uk.ac.ox.well.t2d.async.parser.CsvParsingLogic;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.vcf.VcfException;
import uk.ac.ox.well.t2d.async.vcf.VcfGenotypeHandler;
import uk.ac.ox.well.t2d.async.vcf.VcfHandler;
import uk.ac.ox.well.t2d.async.vcf.VcfPosition;

public class Vcf1kgGenotypeParser
extends TableParser<CharBuffer> {
    public static String SNP_PATTERN = "VT=SNP";
    protected double cutoffFilter;
    protected Pattern sourceFilter;

    public Vcf1kgGenotypeParser(double ctf, String infoPattern) {
        this.setPayloadManager(new CharBufferFactory());
        this.cutoffFilter = ctf;
        if (null != infoPattern) {
            this.sourceFilter = Pattern.compile(infoPattern);
        }
    }

    @Override
    protected TableParsingLogic<CharBuffer> newLogic() {
        CsvParsingLogic atp = new CsvParsingLogic();
        atp.setCellSeparator('\t');
        return atp;
    }

    @Override
    protected TableCellHandler<CharBuffer> newHandler() {
        VcfHandler vcfh = new VcfHandler();
        vcfh.setGenotypeHandler(new SnpFilterHandler(this.sourceFilter, this.cutoffFilter));
        return vcfh;
    }

    public class SnpFilterHandler
    extends VcfGenotypeHandler {
        double log10Cutoff = 0.0;
        Pattern sourcePattern = null;
        boolean isSnp = false;
        boolean isSource = false;
        boolean captureSnp = false;

        public SnpFilterHandler(Pattern pattern, double rawCutoff) {
            this.log10Cutoff = Math.log10(rawCutoff);
            this.sourcePattern = pattern;
        }

        @Override
        public void handlePosition(VcfPosition pos, CharSequenceRegulator reg) throws VcfException {
            super.handlePosition(pos, reg);
            String info = pos.getInfo();
            this.isSnp = info.contains(SNP_PATTERN);
            if (null != this.sourcePattern) {
                Matcher m = this.sourcePattern.matcher(info);
                this.isSource = m.find();
            } else {
                this.isSource = true;
            }
            boolean bl = this.captureSnp = this.isSnp && this.isSource;
            if (this.captureSnp) {
                this.writeTpedSnpData(pos, reg);
            }
        }

        public void writeTpedSnpData(VcfPosition pos, CharSequenceRegulator reg) {
            reg.append(pos.getChrom());
            reg.append("\t");
            if (".".equals(pos.getId())) {
                reg.append(pos.getChrom());
                reg.append("_");
                reg.append(pos.getPos());
            } else {
                reg.append(pos.getId());
            }
            reg.append("\t0\t");
            reg.append(pos.getPos());
        }

        @Override
        public void handleData(CharArraySequence data, CharSequenceRegulator reg) throws VcfException {
            if (this.captureSnp) {
                String[] sfs = this.getPosition().getSubFields(data);
                String[] likelis = this.getPosition().getGenotypeLikelihoods(sfs);
                String call = this.getPosition().getCall(likelis, this.log10Cutoff);
                reg.append("\t");
                reg.append(call);
                if (this.getCell().isEndOfLine()) {
                    reg.append("\n");
                }
            }
        }
    }
}

