/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.vcf.impl;

import java.io.File;
import java.nio.CharBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.ac.ox.well.t2d.async.io.CharBufferFactory;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.CharSequenceRegulator;
import uk.ac.ox.well.t2d.async.parser.CsvParsingLogic;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.vcf.VcfException;
import uk.ac.ox.well.t2d.async.vcf.VcfGenotypeHandler;
import uk.ac.ox.well.t2d.async.vcf.VcfHandler;
import uk.ac.ox.well.t2d.async.vcf.VcfPosition;
import uk.ac.ox.well.t2d.parser.ColumnLoader;

public class Vcf1kgGenotypeSnpFilter
extends TableParser<CharBuffer> {
    public static String SNP_PATTERN = "VT=SNP";
    protected double cutoffFilter;
    protected double log10Cutoff;
    protected Set<String> inclusionChrPos;

    public Vcf1kgGenotypeSnpFilter(double ctf) {
        this.setPayloadManager(new CharBufferFactory());
        this.cutoffFilter = ctf;
        this.log10Cutoff = Math.log10(ctf);
        this.inclusionChrPos = new HashSet<String>();
    }

    public void setChrPosInclusions(String path) throws Exception {
        File f = new File(path);
        ColumnLoader cl = new ColumnLoader(0);
        List<String[]> strs = cl.toArrayList(f);
        HashSet<String> hs = new HashSet<String>();
        for (String[] line : strs) {
            if (line.length < 1) continue;
            hs.add(line[0]);
        }
        System.out.println("Found " + hs.size() + " chr pos ids to include");
        this.inclusionChrPos = hs;
    }

    @Override
    protected TableParsingLogic<CharBuffer> newLogic() {
        CsvParsingLogic atp = new CsvParsingLogic();
        atp.setCellSeparator('\t');
        return atp;
    }

    @Override
    protected TableCellHandler<CharBuffer> newHandler() {
        VcfHandler vcfh = new VcfHandler();
        vcfh.setGenotypeHandler(new SnpFilterHandler());
        return vcfh;
    }

    public class SnpFilterHandler
    extends VcfGenotypeHandler {
        boolean captureSnp = false;

        @Override
        public void handlePosition(VcfPosition pos, CharSequenceRegulator reg) throws VcfException {
            super.handlePosition(pos, reg);
            String info = pos.getInfo();
            this.captureSnp = false;
            if (info.contains(SNP_PATTERN) && Vcf1kgGenotypeSnpFilter.this.inclusionChrPos.contains(pos.getChrPosString())) {
                this.captureSnp = true;
            }
            if (this.captureSnp) {
                this.writeTpedSnpData(pos, reg);
            }
        }

        public void writeTpedSnpData(VcfPosition pos, CharSequenceRegulator reg) {
            reg.append(pos.getChrom());
            reg.append("\t");
            if (".".equals(pos.getId())) {
                reg.append(pos.getChrom());
                reg.append("_");
                reg.append(pos.getPos());
            } else {
                reg.append(pos.getId());
            }
            reg.append("\t0\t");
            reg.append(pos.getPos());
        }

        @Override
        public void handleData(CharArraySequence data, CharSequenceRegulator reg) throws VcfException {
            if (this.captureSnp) {
                String[] sfs = this.getPosition().getSubFields(data);
                String[] likelis = this.getPosition().getGenotypeLikelihoods(sfs);
                String call = this.getPosition().getCall(likelis, Vcf1kgGenotypeSnpFilter.this.log10Cutoff);
                reg.append("\t");
                reg.append(call);
                if (this.getCell().isEndOfLine()) {
                    reg.append("\n");
                }
            }
        }
    }
}

