/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.vcf.impl;

import java.nio.CharBuffer;
import java.util.Map;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.io.CharBufferFactory;
import uk.ac.ox.well.t2d.async.metadata.FileLdrBlock;
import uk.ac.ox.well.t2d.async.metadata.FileWrtrBlock;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.metadata.PropertyReporter;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.CharSequenceRegulator;
import uk.ac.ox.well.t2d.async.parser.CsvParsingLogic;
import uk.ac.ox.well.t2d.async.parser.MapParser;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.ped.tools.GenotypeIndex;
import uk.ac.ox.well.t2d.async.ped.tools.MinorAlleleGenotype;
import uk.ac.ox.well.t2d.async.ped.tools.MinorAlleleGenotypeLdrBlck;
import uk.ac.ox.well.t2d.async.taqman.rig.SeriesBlock;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;
import uk.ac.ox.well.t2d.async.vcf.VcfException;
import uk.ac.ox.well.t2d.async.vcf.VcfGenotypeHandler;
import uk.ac.ox.well.t2d.async.vcf.VcfHandler;

public class VcfGenotypeFinder
extends TableParser<CharBuffer> {
    public static final String VCF_SAMPLE_REMAP_PATH = "VcfGenotypeFinder.SampleRemap.Path";
    public static final String VCF_SAMPLE_REMAP = "VcfGenotypeFinder.SampleRemap";

    public VcfGenotypeFinder() {
        this.setPayloadManager(new CharBufferFactory());
    }

    @Override
    protected TableParsingLogic<CharBuffer> newLogic() {
        CsvParsingLogic atp = new CsvParsingLogic();
        atp.setCellSeparator('\t');
        return atp;
    }

    @Override
    protected TableCellHandler<CharBuffer> newHandler() {
        VcfHandler vcfh = new VcfHandler();
        vcfh.setGenotypeHandler(new GenotypteFinder());
        return vcfh;
    }

    public static class Rig
    extends ExecutionRig {
        @Override
        public PrimaryContract execute() throws Exception {
            SeriesBlock sb = new SeriesBlock();
            sb.addProcessor(new MinorAlleleGenotypeLdrBlck());
            sb.addProcessor(new PropertyReporter.CollectionRprtr().setIsRequired(true).setKey("MinorAlleleGenotype.List").setLabel("MinorAlleleReport"));
            sb.addProcessor(new MinorAlleleGenotypeLdrBlck.MinorAlleleGenotypeIndexer());
            MapParser.HashMapLdrBlock mapLdr = new MapParser.HashMapLdrBlock();
            mapLdr.setInputPropertyKey(VcfGenotypeFinder.VCF_SAMPLE_REMAP_PATH);
            mapLdr.setOutputPropertyKey(VcfGenotypeFinder.VCF_SAMPLE_REMAP);
            sb.addProcessor(mapLdr);
            sb.addProcessor(new PropertyReporter.MapRprtr().setIsRequired(false).setKey(VcfGenotypeFinder.VCF_SAMPLE_REMAP).setLabel("VcfSampleRemap"));
            sb.addProcessor(new MetadataReader().setPropertyKey("IOProperties.IN_PATH"));
            sb.addProcessor(new FileLdrBlock.Character());
            sb.addProcessor(new VcfGenotypeFinder());
            sb.addProcessor(new FileWrtrBlock.CharWrtr());
            return this.execute(sb);
        }
    }

    public class GenotypteFinder
    extends VcfGenotypeHandler {
        boolean isHeaderWritten;
        GenotypeIndex idx;
        Map<String, String> sampleMap;

        @Override
        public void handleStart(Contract contract) {
            this.idx = (GenotypeIndex)contract.get("MinorAlleleGenotype.Index");
            if (null == this.idx) {
                throw new RequiredPropertyValueNotFound("MinorAlleleGenotype.Index");
            }
            this.sampleMap = (Map)contract.get(VcfGenotypeFinder.VCF_SAMPLE_REMAP);
            this.isHeaderWritten = false;
            super.handleStart(contract);
        }

        @Override
        public void handleData(CharArraySequence data, CharSequenceRegulator reg) throws VcfException {
            String chr = this.getPosition().getChrom();
            String pos = this.getPosition().getPos();
            String iid = this.getSampleId();
            MinorAlleleGenotype mag = (MinorAlleleGenotype)this.idx.get(chr, pos, iid = this.remapIid(iid));
            if (null != mag) {
                this.writeHeader(reg);
                this.writeEntry(mag, data, reg);
            }
        }

        public String remapIid(String iid) {
            String riid;
            if (null != this.sampleMap && null != (riid = this.sampleMap.get(iid))) {
                return riid;
            }
            return iid;
        }

        public void writeEntry(MinorAlleleGenotype mag, CharArraySequence data, CharSequenceRegulator reg) throws VcfException {
            reg.append(mag.toString());
            reg.append("\t");
            String[] sfs = this.getPosition().getSubFields(data);
            if (sfs.length == 1 && (sfs[0].equals("./.") || sfs[0].equals(".|."))) {
                reg.append(".\t.\t.");
            } else {
                String[] alleles = this.getPosition().getAlleles(sfs);
                reg.append(alleles[0] + alleles[1]);
                reg.append("\t");
                String gq = this.getPosition().getSubFieldValue(sfs, "GQ");
                reg.append(gq);
                reg.append("\t");
                String rd = this.getPosition().getSubFieldValue(sfs, "DP");
                reg.append(rd);
            }
            reg.append("\t");
            reg.append(data);
            reg.append("\t");
            reg.append(this.getPosition().getSubfieldString());
            reg.append("\t");
            reg.append(this.getPosition().getId());
            reg.append("\t");
            reg.append(this.getPosition().getRef());
            reg.append(this.getPosition().getAlt());
            reg.append("\t");
            reg.append(this.getPosition().getQual());
            reg.append("\t");
            reg.append(this.getPosition().getFilter());
            reg.append("\t");
            reg.append(this.getPosition().getInfo());
            reg.append("\n");
        }

        public void writeHeader(CharSequenceRegulator reg) {
            if (!this.isHeaderWritten) {
                reg.append(new MinorAlleleGenotype.Header().toString());
                reg.append("\t");
                reg.append("VCF_GT_AL\tVCF_GT_GQ\tVCF_GT_DP\t");
                reg.append("VCF_GT_DATA\tVCF_GT_KEY\t");
                reg.append("VCF_POS_ID\tVCF_POS_AL\tVCF_POS_QUAL\tVCF_POS_FILTER\tVCF_POS_INFO");
                reg.append("\n");
            }
            this.isHeaderWritten = true;
        }
    }
}

