/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.vcf.impl;

import java.nio.CharBuffer;
import uk.ac.ox.well.t2d.async.io.CharBufferFactory;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.CharSequenceRegulator;
import uk.ac.ox.well.t2d.async.parser.CsvParsingLogic;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.vcf.VcfException;
import uk.ac.ox.well.t2d.async.vcf.VcfGenotypeHandler;
import uk.ac.ox.well.t2d.async.vcf.VcfHandler;
import uk.ac.ox.well.t2d.async.vcf.VcfPosition;

public class VcfGot2dGenotypeParser
extends TableParser<CharBuffer> {
    protected double cutoffFilter;

    public VcfGot2dGenotypeParser(double ctf) {
        this.setPayloadManager(new CharBufferFactory());
        this.cutoffFilter = ctf;
    }

    @Override
    protected TableParsingLogic<CharBuffer> newLogic() {
        CsvParsingLogic atp = new CsvParsingLogic();
        atp.setCellSeparator('\t');
        return atp;
    }

    @Override
    protected TableCellHandler<CharBuffer> newHandler() {
        VcfHandler vcfh = new VcfHandler();
        vcfh.setGenotypeHandler(new SnpFilterHandler(this.cutoffFilter));
        return vcfh;
    }

    public class SnpFilterHandler
    extends VcfGenotypeHandler {
        double cutoff = 0.0;

        public SnpFilterHandler(double ctf) {
            this.cutoff = ctf;
        }

        @Override
        public void handlePosition(VcfPosition pos, CharSequenceRegulator reg) throws VcfException {
            super.handlePosition(pos, reg);
            this.writeTpedSnpData(pos, reg);
        }

        public void writeTpedSnpData(VcfPosition pos, CharSequenceRegulator reg) {
            reg.append(pos.getChrom());
            reg.append("\t");
            if (".".equals(pos.getId())) {
                reg.append(pos.getChrom());
                reg.append("_");
                reg.append(pos.getPos());
            } else {
                reg.append(pos.getId());
            }
            reg.append("\t0\t");
            reg.append(pos.getPos());
        }

        @Override
        public void handleData(CharArraySequence data, CharSequenceRegulator reg) throws VcfException {
            String[] sfs = this.getPosition().getSubFields(data);
            if (sfs.length == 1 && (sfs[0].equals("./.") || sfs[0].equals(".|."))) {
                reg.append("\t0 0");
                if (this.getCell().isEndOfLine()) {
                    reg.append("\n");
                }
                return;
            }
            String gq = this.getPosition().getSubFieldValue(sfs, "GQ");
            double gqd = 0.0;
            try {
                gqd = Double.parseDouble(gq);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (this.cutoff <= gqd) {
                String[] alleles = this.getPosition().getAlleles(sfs);
                reg.append("\t");
                reg.append(alleles[0]);
                reg.append(" ");
                reg.append(alleles[1]);
            } else {
                reg.append("\t0 0");
            }
            if (this.getCell().isEndOfLine()) {
                reg.append("\n");
            }
        }
    }
}

