/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.vcf.impl;

import java.io.File;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.Contractor;
import uk.ac.ox.well.t2d.async.contracts.Demultiplexer;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.contracts.SerialMultiplexer;
import uk.ac.ox.well.t2d.async.gzip.GzipDecoder;
import uk.ac.ox.well.t2d.async.io.AsynchronousFileChannelReader;
import uk.ac.ox.well.t2d.async.io.AsynchronousFileChannelWriter;
import uk.ac.ox.well.t2d.async.io.ByteBufferFactory;
import uk.ac.ox.well.t2d.async.io.CharBufferFactory;
import uk.ac.ox.well.t2d.async.io.CharacterDecoder;
import uk.ac.ox.well.t2d.async.io.CharacterEncoder;
import uk.ac.ox.well.t2d.async.io.PathScanner;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.processors.CollectionSerializer;
import uk.ac.ox.well.t2d.async.processors.PayloadReporter;
import uk.ac.ox.well.t2d.async.processors.Reporter;

public class VcfParsingPipeline
implements Runnable {
    private int executorCount = 3;
    private int bucketCount = 3;
    private int bufferCapacity = 100000;
    private String directory;
    private String stem;
    private TableParser vcfParser;

    @Override
    public void run() {
        System.out.format("Running Vcf Pipeline: %d Executors, %d Buckets, %,d Capacity%n", this.executorCount, this.bucketCount, this.bufferCapacity);
        if (this.bucketCount <= 0) {
            throw new RuntimeException("Bucket Count cannot be zero. Found: " + this.bucketCount);
        }
        if (this.executorCount <= 0) {
            throw new RuntimeException("Executor Count cannot be zero. Found: " + this.executorCount);
        }
        if (this.bufferCapacity <= 0) {
            throw new RuntimeException("Buffer Capacity cannot be zero. Found: " + this.bufferCapacity);
        }
        ExecutorService exe = Executors.newFixedThreadPool(this.getExecutorCount());
        PathScanner ds = new PathScanner();
        ds.setBucketCount(this.getBucketCount());
        ds.setExecutorService(exe);
        ds.addPattern("glob:**.{vcf.gz}");
        CollectionSerializer cs = new CollectionSerializer();
        cs.setExecutorService(exe);
        cs.setBucketCount(this.getBucketCount());
        SerialMultiplexer mx = new SerialMultiplexer();
        mx.setExecutorService(exe);
        mx.setBucketCount(this.getBucketCount());
        AsynchronousFileChannelReader cr = new AsynchronousFileChannelReader();
        ((ByteBufferFactory)cr.getPayloadManager()).setCapacity(this.getBufferCapacity());
        cr.setBucketCount(this.getBucketCount());
        cr.setExecutorService(exe);
        GzipDecoder gzd = new GzipDecoder();
        ((ByteBufferFactory)gzd.getPayloadManager()).setCapacity(this.getBufferCapacity());
        gzd.setBucketCount(this.getBucketCount());
        gzd.setExecutorService(exe);
        CharacterDecoder cd = new CharacterDecoder();
        ((CharBufferFactory)cd.getPayloadManager()).setCapacity(this.getBufferCapacity());
        cd.setBucketCount(this.getBucketCount());
        cd.setExecutorService(exe);
        TableParser sf = this.getVcfParser();
        ((CharBufferFactory)sf.getPayloadManager()).setCapacity(this.getBufferCapacity());
        sf.setBucketCount(this.getBucketCount());
        sf.setExecutorService(exe);
        CharacterEncoder ce = new CharacterEncoder();
        ((ByteBufferFactory)ce.getPayloadManager()).setCapacity(this.getBufferCapacity());
        ce.setBucketCount(this.getBucketCount());
        ce.setExecutorService(exe);
        Demultiplexer dx = new Demultiplexer();
        AsynchronousFileChannelWriter cw = new AsynchronousFileChannelWriter();
        cw.setBucketCount(this.getBucketCount());
        cw.setExecutorService(exe);
        PayloadReporter r1 = new PayloadReporter("Path");
        Reporter r2 = new Reporter("Decoder");
        r2.setEnabled(false);
        Reporter r3 = new Reporter("Demultiplexer");
        r3.setEnabled(false);
        Reporter r4 = new Reporter("FileReader");
        r4.setEnabled(false);
        Reporter r5 = new Reporter("Gzip");
        r5.setEnabled(false);
        Reporter r6 = new Reporter("FileWriter");
        r6.setEnabled(false);
        ds.setProcessor(cs);
        cs.setProcessor(r1);
        r1.setProcessor((Processor)mx);
        mx.setProcessor(cr);
        cr.setProcessor(r4);
        r4.setProcessor((Processor)gzd);
        gzd.setProcessor(r5);
        r5.setProcessor((Processor)cd);
        cd.setProcessor(r2);
        r2.setProcessor((Processor)sf);
        sf.setProcessor(ce);
        ce.setProcessor(dx);
        dx.setProcessor(r3);
        r3.setProcessor((Processor)cw);
        cw.setProcessor(r6);
        Contractor c = new Contractor();
        c.setStartPoint(ds);
        c.setEndPoint(r6);
        cw.commence();
        dx.commence();
        ce.commence();
        sf.commence();
        gzd.commence();
        cd.commence();
        cr.commence();
        mx.commence();
        cs.commence();
        ds.commence();
        File of = new File(this.getStem() + ".tped");
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("IOProperties.OUT_PATH", of.toPath());
        long start = System.currentTimeMillis();
        try {
            PrimaryContract pc = c.initiate(this.getDirectory(), meta);
            long end = System.currentTimeMillis();
            System.out.printf("Parse complete in %,d ms%n", end - start);
            if (pc.getResults().isEmpty()) {
                System.out.println("No Result Objects found");
            } else {
                Object result = pc.getResults().get(0);
                System.out.println("Result: " + result);
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getStem() {
        return this.stem;
    }

    public void setStem(String stem) {
        this.stem = stem;
    }

    public int getExecutorCount() {
        return this.executorCount;
    }

    public void setExecutorCount(int executorCount) {
        this.executorCount = executorCount;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public void setBucketCount(int bucketCount) {
        this.bucketCount = bucketCount;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public void setBufferCapacity(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    public TableParser getVcfParser() {
        return this.vcfParser;
    }

    public void setVcfParser(TableParser vcfParser) {
        this.vcfParser = vcfParser;
    }
}

